/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.taskmanager;

import eu.stratosphere.core.io.IOReadableWritable;
import eu.stratosphere.core.io.StringRecord;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.nephele.execution.ExecutionState;
import eu.stratosphere.nephele.executiongraph.ExecutionVertexID;
import eu.stratosphere.nephele.jobgraph.JobID;
import eu.stratosphere.nephele.util.EnumUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class TaskExecutionState
implements IOReadableWritable {
    private JobID jobID = null;
    private ExecutionVertexID executionVertexID = null;
    private ExecutionState executionState = null;
    private String description = null;

    public TaskExecutionState(JobID jobID, ExecutionVertexID id, ExecutionState executionState, String description) {
        this.jobID = jobID;
        this.executionVertexID = id;
        this.executionState = executionState;
        this.description = description;
    }

    public TaskExecutionState() {
    }

    public String getDescription() {
        return this.description;
    }

    public ExecutionVertexID getID() {
        return this.executionVertexID;
    }

    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public void read(DataInputView in) throws IOException {
        boolean isNotNull = in.readBoolean();
        if (isNotNull) {
            this.jobID = new JobID();
            this.jobID.read(in);
        } else {
            this.jobID = null;
        }
        isNotNull = in.readBoolean();
        if (isNotNull) {
            this.executionVertexID = new ExecutionVertexID();
            this.executionVertexID.read(in);
        } else {
            this.executionVertexID = null;
        }
        this.executionState = EnumUtils.readEnum((DataInput)in, ExecutionState.class);
        this.description = StringRecord.readString((DataInput)in);
    }

    public void write(DataOutputView out) throws IOException {
        if (this.jobID == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.jobID.write(out);
        }
        if (this.executionVertexID == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.executionVertexID.write(out);
        }
        EnumUtils.writeEnum((DataOutput)out, this.executionState);
        StringRecord.writeString((DataOutput)out, (String)this.description);
    }
}

