/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.taskmanager;

import eu.stratosphere.core.io.IOReadableWritable;
import eu.stratosphere.core.io.StringRecord;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.nephele.executiongraph.ExecutionVertexID;
import eu.stratosphere.nephele.util.EnumUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class AbstractTaskResult
implements IOReadableWritable {
    private ExecutionVertexID vertexID;
    private ReturnCode returnCode;
    private String description;

    public AbstractTaskResult(ExecutionVertexID vertexID, ReturnCode returnCode) {
        this.vertexID = vertexID;
        this.returnCode = returnCode;
    }

    public AbstractTaskResult() {
        this.vertexID = null;
        this.returnCode = ReturnCode.SUCCESS;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ExecutionVertexID getVertexID() {
        return this.vertexID;
    }

    public ReturnCode getReturnCode() {
        return this.returnCode;
    }

    public void read(DataInputView in) throws IOException {
        boolean isNotNull = in.readBoolean();
        if (isNotNull) {
            this.vertexID = new ExecutionVertexID();
            this.vertexID.read(in);
        }
        this.returnCode = EnumUtils.readEnum((DataInput)in, ReturnCode.class);
        this.description = StringRecord.readString((DataInput)in);
    }

    public void write(DataOutputView out) throws IOException {
        if (this.vertexID == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.vertexID.write(out);
        }
        EnumUtils.writeEnum((DataOutput)out, this.returnCode);
        StringRecord.writeString((DataOutput)out, (String)this.description);
    }

    public static enum ReturnCode {
        SUCCESS,
        DEPLOYMENT_ERROR,
        IPC_ERROR,
        NO_INSTANCE,
        ILLEGAL_STATE,
        TASK_NOT_FOUND,
        INSUFFICIENT_RESOURCES;

    }
}

