/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.services.memorymanager.spi;

import eu.stratosphere.core.memory.MemorySegment;
import eu.stratosphere.nephele.services.memorymanager.MemoryAllocationException;
import eu.stratosphere.nephele.services.memorymanager.MemoryManager;
import eu.stratosphere.nephele.template.AbstractInvokable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultMemoryManager
implements MemoryManager {
    public static final int DEFAULT_PAGE_SIZE = 32768;
    public static final int MIN_PAGE_SIZE = 4096;
    private static final Log LOG = LogFactory.getLog(DefaultMemoryManager.class);
    private final Object lock = new Object();
    private final ArrayDeque<byte[]> freeSegments;
    private final HashMap<AbstractInvokable, Set<DefaultMemorySegment>> allocatedSegments;
    private final long roundingMask;
    private final int pageSize;
    private final int pageSizeBits;
    private final int totalNumPages;
    private boolean isShutDown;
    private final int numberOfSlots;
    private final long memorySize;

    public DefaultMemoryManager(long memorySize, int numberOfSlots) {
        this(memorySize, numberOfSlots, 32768);
    }

    public DefaultMemoryManager(long memorySize, int numberOfSlots, int pageSize) {
        if (memorySize <= 0L) {
            throw new IllegalArgumentException("Size of total memory must be positive.");
        }
        if (pageSize < 4096) {
            throw new IllegalArgumentException("The page size must be at least 4096 bytes.");
        }
        if ((pageSize & pageSize - 1) != 0) {
            throw new IllegalArgumentException("The given page size is not a power of two.");
        }
        this.memorySize = memorySize;
        this.numberOfSlots = numberOfSlots;
        this.pageSize = pageSize;
        this.roundingMask = (long)(pageSize - 1) ^ 0xFFFFFFFFFFFFFFFFL;
        int log = 0;
        while ((pageSize >>>= 1) != 0) {
            ++log;
        }
        this.pageSizeBits = log;
        this.totalNumPages = this.getNumPages(memorySize);
        if (this.totalNumPages < 1) {
            throw new IllegalArgumentException("The given amount of memory amounted to less than one page.");
        }
        this.freeSegments = new ArrayDeque(this.totalNumPages);
        this.allocatedSegments = new HashMap();
        for (int i = 0; i < this.totalNumPages; ++i) {
            this.freeSegments.add(new byte[this.pageSize]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isShutDown) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Shutting down MemoryManager instance " + this.toString()));
                }
                this.isShutDown = true;
                this.freeSegments.clear();
                for (Set<DefaultMemorySegment> segments : this.allocatedSegments.values()) {
                    for (DefaultMemorySegment seg : segments) {
                        seg.destroy();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verifyEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.freeSegments.size() == this.totalNumPages;
        }
    }

    @Override
    public List<MemorySegment> allocatePages(AbstractInvokable owner, int numPages) throws MemoryAllocationException {
        ArrayList<MemorySegment> segs = new ArrayList<MemorySegment>(numPages);
        this.allocatePages(owner, segs, numPages);
        return segs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void allocatePages(AbstractInvokable owner, List<MemorySegment> target, int numPages) throws MemoryAllocationException {
        if (owner == null) {
            throw new IllegalAccessError("The memory owner must not be null.");
        }
        if (target instanceof ArrayList) {
            ((ArrayList)target).ensureCapacity(numPages);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isShutDown) {
                throw new IllegalStateException("Memory manager has been shut down.");
            }
            if (numPages > this.freeSegments.size()) {
                throw new MemoryAllocationException("Could not allocate " + numPages + " pages. Only " + this.freeSegments.size() + " pages are remaining.");
            }
            Set<DefaultMemorySegment> segmentsForOwner = this.allocatedSegments.get(owner);
            if (segmentsForOwner == null) {
                segmentsForOwner = new HashSet<DefaultMemorySegment>(4 * numPages / 3 + 1);
                this.allocatedSegments.put(owner, segmentsForOwner);
            }
            for (int i = numPages; i > 0; --i) {
                byte[] buffer = this.freeSegments.poll();
                DefaultMemorySegment segment = new DefaultMemorySegment(owner, buffer);
                target.add(segment);
                segmentsForOwner.add(segment);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(MemorySegment segment) {
        if (segment == null || segment.isFreed() || !(segment instanceof DefaultMemorySegment)) {
            return;
        }
        DefaultMemorySegment defSeg = (DefaultMemorySegment)segment;
        AbstractInvokable owner = defSeg.owner;
        Object object = this.lock;
        synchronized (object) {
            if (this.isShutDown) {
                throw new IllegalStateException("Memory manager has been shut down.");
            }
            try {
                Set<DefaultMemorySegment> segsForOwner = this.allocatedSegments.get(owner);
                if (segsForOwner != null) {
                    segsForOwner.remove((Object)defSeg);
                    if (segsForOwner.isEmpty()) {
                        this.allocatedSegments.remove(owner);
                    }
                }
            }
            catch (Throwable t) {
                LOG.error((Object)"Error removing book-keeping reference to allocated memory segment.", t);
            }
            finally {
                byte[] buffer = defSeg.destroy();
                this.freeSegments.add(buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends MemorySegment> void release(Collection<T> segments) {
        if (segments == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isShutDown) {
                throw new IllegalStateException("Memory manager has been shut down.");
            }
            Iterator<T> segmentsIterator = segments.iterator();
            AbstractInvokable lastOwner = null;
            Set<DefaultMemorySegment> segsForOwner = null;
            while (segmentsIterator.hasNext()) {
                MemorySegment seg = (MemorySegment)segmentsIterator.next();
                if (seg.isFreed()) continue;
                DefaultMemorySegment defSeg = (DefaultMemorySegment)seg;
                AbstractInvokable owner = defSeg.owner;
                try {
                    if (lastOwner != owner) {
                        lastOwner = owner;
                        segsForOwner = this.allocatedSegments.get(owner);
                    }
                    if (segsForOwner == null) continue;
                    segsForOwner.remove((Object)defSeg);
                    if (!segsForOwner.isEmpty()) continue;
                    this.allocatedSegments.remove(owner);
                }
                catch (Throwable t) {
                    LOG.error((Object)"Error removing book-keeping reference to allocated memory segment.", t);
                }
                finally {
                    byte[] buffer = defSeg.destroy();
                    this.freeSegments.add(buffer);
                }
            }
            segments.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseAll(AbstractInvokable owner) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isShutDown) {
                throw new IllegalStateException("Memory manager has been shut down.");
            }
            Set<DefaultMemorySegment> segments = this.allocatedSegments.remove(owner);
            if (segments == null || segments.isEmpty()) {
                return;
            }
            for (DefaultMemorySegment seg : segments) {
                byte[] buffer = seg.destroy();
                this.freeSegments.add(buffer);
            }
            segments.clear();
        }
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public long getMemorySize() {
        return this.memorySize;
    }

    @Override
    public int computeNumberOfPages(double fraction) {
        return this.getRelativeNumPages(fraction);
    }

    @Override
    public long computeMemorySize(double fraction) {
        return this.pageSize * this.computeNumberOfPages(fraction);
    }

    @Override
    public long roundDownToPageSizeMultiple(long numBytes) {
        return numBytes & this.roundingMask;
    }

    private final int getNumPages(long numBytes) {
        if (numBytes < 0L) {
            throw new IllegalArgumentException("The number of bytes to allocate must not be negative.");
        }
        long numPages = numBytes >>> this.pageSizeBits;
        if (numPages <= Integer.MAX_VALUE) {
            return (int)numPages;
        }
        throw new IllegalArgumentException("The given number of bytes correstponds to more than MAX_INT pages.");
    }

    private final int getRelativeNumPages(double fraction) {
        if (fraction <= 0.0 || fraction > 1.0) {
            throw new IllegalArgumentException("The fraction of memory to allocate must within (0, 1].");
        }
        return (int)((double)this.totalNumPages * fraction / (double)this.numberOfSlots);
    }

    private static final class DefaultMemorySegment
    extends MemorySegment {
        private AbstractInvokable owner;

        DefaultMemorySegment(AbstractInvokable owner, byte[] memory) {
            super(memory);
            this.owner = owner;
        }

        byte[] destroy() {
            byte[] buffer = this.memory;
            this.memory = null;
            this.wrapper = null;
            return buffer;
        }
    }
}

