/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.services.memorymanager;

import eu.stratosphere.core.memory.MemoryUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import sun.misc.Unsafe;

public class UnsafeMemorySegment {
    private static final boolean CHECKED = false;
    protected byte[] memory;
    protected ByteBuffer wrapper;
    private static final Unsafe UNSAFE = MemoryUtils.UNSAFE;
    private static final long BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    private static final boolean LITTLE_ENDIAN = MemoryUtils.NATIVE_BYTE_ORDER == ByteOrder.LITTLE_ENDIAN;

    public UnsafeMemorySegment(byte[] memory) {
        this.memory = memory;
    }

    public final boolean isFreed() {
        return this.memory == null;
    }

    public final int size() {
        return this.memory.length;
    }

    @Deprecated
    public final byte[] getBackingArray() {
        return this.memory;
    }

    @Deprecated
    public final int translateOffset(int offset) {
        return offset;
    }

    public ByteBuffer wrap(int offset, int length) {
        if (offset > this.memory.length || offset > this.memory.length - length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.wrapper == null) {
            this.wrapper = ByteBuffer.wrap(this.memory, offset, length);
        } else {
            this.wrapper.position(offset);
            this.wrapper.limit(offset + length);
        }
        return this.wrapper;
    }

    public final byte get(int index) {
        return this.memory[index];
    }

    public final void put(int index, byte b) {
        this.memory[index] = b;
    }

    public final void get(int index, byte[] dst) {
        this.get(index, dst, 0, dst.length);
    }

    public final void put(int index, byte[] src) {
        this.put(index, src, 0, src.length);
    }

    public final void get(int index, byte[] dst, int offset, int length) {
        System.arraycopy(this.memory, index, dst, offset, length);
    }

    public final void put(int index, byte[] src, int offset, int length) {
        System.arraycopy(src, offset, this.memory, index, length);
    }

    public final void get(DataOutput out, int offset, int length) throws IOException {
        out.write(this.memory, offset, length);
    }

    public final void put(DataInput in, int offset, int length) throws IOException {
        in.readFully(this.memory, offset, length);
    }

    public final boolean getBoolean(int index) {
        return this.memory[index] != 0;
    }

    public final void putBoolean(int index, boolean value) {
        this.memory[index] = (byte)(value ? 1 : 0);
    }

    public final char getChar(int index) {
        return (char)((this.memory[index] & 0xFF) << 8 | this.memory[index + 1] & 0xFF);
    }

    public final void putChar(int index, char value) {
        this.memory[index] = (byte)(value >> 8);
        this.memory[index + 1] = (byte)value;
    }

    public final short getShort(int index) {
        return (short)((this.memory[index] & 0xFF) << 8 | this.memory[index + 1] & 0xFF);
    }

    public final void putShort(int index, short value) {
        this.memory[index] = (byte)(value >> 8);
        this.memory[index + 1] = (byte)value;
    }

    public final int getInt(int index) {
        return UNSAFE.getInt(this.memory, BASE_OFFSET + (long)index);
    }

    public final int getIntLittleEndian(int index) {
        if (LITTLE_ENDIAN) {
            return this.getInt(index);
        }
        return Integer.reverseBytes(this.getInt(index));
    }

    public final int getIntBigEndian(int index) {
        if (LITTLE_ENDIAN) {
            return Integer.reverseBytes(this.getInt(index));
        }
        return this.getInt(index);
    }

    public final void putInt(int index, int value) {
        UNSAFE.putInt(this.memory, BASE_OFFSET + (long)index, value);
    }

    public final void putIntLittleEndian(int index, int value) {
        if (LITTLE_ENDIAN) {
            this.putInt(index, value);
        } else {
            this.putInt(index, Integer.reverseBytes(value));
        }
    }

    public final void putIntBigEndian(int index, int value) {
        if (LITTLE_ENDIAN) {
            this.putInt(index, Integer.reverseBytes(value));
        } else {
            this.putInt(index, value);
        }
    }

    public final long getLong(int index) {
        return UNSAFE.getLong(this.memory, BASE_OFFSET + (long)index);
    }

    public final long getLongLittleEndian(int index) {
        if (LITTLE_ENDIAN) {
            return this.getLong(index);
        }
        return Long.reverseBytes(this.getLong(index));
    }

    public final long getLongBigEndian(int index) {
        if (LITTLE_ENDIAN) {
            return Long.reverseBytes(this.getLong(index));
        }
        return this.getLong(index);
    }

    public final void putLong(int index, long value) {
        UNSAFE.putLong(this.memory, BASE_OFFSET + (long)index, value);
    }

    public final void putLongLittleEndian(int index, long value) {
        if (LITTLE_ENDIAN) {
            this.putLong(index, value);
        } else {
            this.putLong(index, Long.reverseBytes(value));
        }
    }

    public final void putLongBigEndian(int index, long value) {
        if (LITTLE_ENDIAN) {
            this.putLong(index, Long.reverseBytes(value));
        } else {
            this.putLong(index, value);
        }
    }

    public final float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    public final float getFloatLittleEndian(int index) {
        return Float.intBitsToFloat(this.getIntLittleEndian(index));
    }

    public final float getFloatBigEndian(int index) {
        return Float.intBitsToFloat(this.getIntBigEndian(index));
    }

    public final void putFloat(int index, float value) {
        this.putInt(index, Float.floatToRawIntBits(value));
    }

    public final void putFloatLittleEndian(int index, float value) {
        this.putIntLittleEndian(index, Float.floatToRawIntBits(value));
    }

    public final void putFloatBigEndian(int index, float value) {
        this.putIntBigEndian(index, Float.floatToRawIntBits(value));
    }

    public final double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    public final double getDoubleLittleEndian(int index) {
        return Double.longBitsToDouble(this.getLongLittleEndian(index));
    }

    public final double getDoubleBigEndian(int index) {
        return Double.longBitsToDouble(this.getLongBigEndian(index));
    }

    public final void putDouble(int index, double value) {
        this.putLong(index, Double.doubleToRawLongBits(value));
    }

    public final void putDoubleLittleEndian(int index, double value) {
        this.putLongLittleEndian(index, Double.doubleToRawLongBits(value));
    }

    public final void putDoubleBigEndian(int index, double value) {
        this.putLongBigEndian(index, Double.doubleToRawLongBits(value));
    }
}

