/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.services.memorymanager;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public class DirectMemorySegment {
    protected byte[] memory;
    protected ByteBuffer wrapper;

    public DirectMemorySegment(byte[] memory) {
        this.memory = memory;
    }

    public final boolean isFreed() {
        return this.memory == null;
    }

    public final int size() {
        return this.memory.length;
    }

    public final byte[] getBackingArray() {
        return this.memory;
    }

    public final int translateOffset(int offset) {
        return offset;
    }

    public ByteBuffer wrap(int offset, int length) {
        if (offset > this.memory.length || offset > this.memory.length - length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.wrapper == null) {
            this.wrapper = ByteBuffer.wrap(this.memory, offset, length);
        } else {
            this.wrapper.position(offset);
            this.wrapper.limit(offset + length);
        }
        return this.wrapper;
    }

    public final byte get(int index) {
        return this.memory[index];
    }

    public final void put(int index, byte b) {
        this.memory[index] = b;
    }

    public final void get(int index, byte[] dst) {
        this.get(index, dst, 0, dst.length);
    }

    public final void put(int index, byte[] src) {
        this.put(index, src, 0, src.length);
    }

    public final void get(int index, byte[] dst, int offset, int length) {
        System.arraycopy(this.memory, index, dst, offset, length);
    }

    public final void put(int index, byte[] src, int offset, int length) {
        System.arraycopy(src, offset, this.memory, index, length);
    }

    public final void get(DataOutput out, int offset, int length) throws IOException {
        out.write(this.memory, offset, length);
    }

    public final void put(DataInput in, int offset, int length) throws IOException {
        in.readFully(this.memory, offset, length);
    }

    public final boolean getBoolean(int index) {
        return this.memory[index] != 0;
    }

    public final void putBoolean(int index, boolean value) {
        this.memory[index] = (byte)(value ? 1 : 0);
    }

    public final char getChar(int index) {
        return (char)((this.memory[index] & 0xFF) << 8 | this.memory[index + 1] & 0xFF);
    }

    public final void putChar(int index, char value) {
        this.memory[index] = (byte)(value >> 8);
        this.memory[index + 1] = (byte)value;
    }

    public final short getShort(int index) {
        return (short)((this.memory[index] & 0xFF) << 8 | this.memory[index + 1] & 0xFF);
    }

    public final void putShort(int index, short value) {
        this.memory[index] = (byte)(value >> 8);
        this.memory[index + 1] = (byte)value;
    }

    public final int getInt(int index) {
        return (this.memory[index] & 0xFF) << 24 | (this.memory[index + 1] & 0xFF) << 16 | (this.memory[index + 2] & 0xFF) << 8 | this.memory[index + 3] & 0xFF;
    }

    public final int getIntLittleEndian(int index) {
        return this.memory[index] & 0xFF | (this.memory[index + 1] & 0xFF) << 8 | (this.memory[index + 2] & 0xFF) << 16 | (this.memory[index + 3] & 0xFF) << 24;
    }

    public final int getIntBigEndian(int index) {
        return (this.memory[index] & 0xFF) << 24 | (this.memory[index + 1] & 0xFF) << 16 | (this.memory[index + 2] & 0xFF) << 8 | this.memory[index + 3] & 0xFF;
    }

    public final void putInt(int index, int value) {
        this.memory[index] = (byte)(value >> 24);
        this.memory[index + 1] = (byte)(value >> 16);
        this.memory[index + 2] = (byte)(value >> 8);
        this.memory[index + 3] = (byte)value;
    }

    public final void putIntLittleEndian(int index, int value) {
        this.memory[index] = (byte)value;
        this.memory[index + 1] = (byte)(value >> 8);
        this.memory[index + 2] = (byte)(value >> 16);
        this.memory[index + 3] = (byte)(value >> 24);
    }

    public final void putIntBigEndian(int index, int value) {
        this.memory[index] = (byte)(value >> 24);
        this.memory[index + 1] = (byte)(value >> 16);
        this.memory[index + 2] = (byte)(value >> 8);
        this.memory[index + 3] = (byte)value;
    }

    public final long getLong(int index) {
        return ((long)this.memory[index] & 0xFFL) << 56 | ((long)this.memory[index + 1] & 0xFFL) << 48 | ((long)this.memory[index + 2] & 0xFFL) << 40 | ((long)this.memory[index + 3] & 0xFFL) << 32 | ((long)this.memory[index + 4] & 0xFFL) << 24 | ((long)this.memory[index + 5] & 0xFFL) << 16 | ((long)this.memory[index + 6] & 0xFFL) << 8 | (long)this.memory[index + 7] & 0xFFL;
    }

    public final long getLongLittleEndian(int index) {
        return (long)this.memory[index] & 0xFFL | ((long)this.memory[index + 1] & 0xFFL) << 8 | ((long)this.memory[index + 2] & 0xFFL) << 16 | ((long)this.memory[index + 3] & 0xFFL) << 24 | ((long)this.memory[index + 4] & 0xFFL) << 32 | ((long)this.memory[index + 5] & 0xFFL) << 40 | ((long)this.memory[index + 6] & 0xFFL) << 48 | ((long)this.memory[index + 7] & 0xFFL) << 56;
    }

    public final long getLongBigEndian(int index) {
        return ((long)this.memory[index] & 0xFFL) << 56 | ((long)this.memory[index + 1] & 0xFFL) << 48 | ((long)this.memory[index + 2] & 0xFFL) << 40 | ((long)this.memory[index + 3] & 0xFFL) << 32 | ((long)this.memory[index + 4] & 0xFFL) << 24 | ((long)this.memory[index + 5] & 0xFFL) << 16 | ((long)this.memory[index + 6] & 0xFFL) << 8 | (long)this.memory[index + 7] & 0xFFL;
    }

    public final void putLong(int index, long value) {
        this.memory[index] = (byte)(value >> 56);
        this.memory[index + 1] = (byte)(value >> 48);
        this.memory[index + 2] = (byte)(value >> 40);
        this.memory[index + 3] = (byte)(value >> 32);
        this.memory[index + 4] = (byte)(value >> 24);
        this.memory[index + 5] = (byte)(value >> 16);
        this.memory[index + 6] = (byte)(value >> 8);
        this.memory[index + 7] = (byte)value;
    }

    public final void putLongLittleEndian(int index, long value) {
        this.memory[index] = (byte)value;
        this.memory[index + 1] = (byte)(value >> 8);
        this.memory[index + 2] = (byte)(value >> 16);
        this.memory[index + 3] = (byte)(value >> 24);
        this.memory[index + 4] = (byte)(value >> 32);
        this.memory[index + 5] = (byte)(value >> 40);
        this.memory[index + 6] = (byte)(value >> 48);
        this.memory[index + 7] = (byte)(value >> 56);
    }

    public final void putLongBigEndian(int index, long value) {
        this.memory[index] = (byte)(value >> 56);
        this.memory[index + 1] = (byte)(value >> 48);
        this.memory[index + 2] = (byte)(value >> 40);
        this.memory[index + 3] = (byte)(value >> 32);
        this.memory[index + 4] = (byte)(value >> 24);
        this.memory[index + 5] = (byte)(value >> 16);
        this.memory[index + 6] = (byte)(value >> 8);
        this.memory[index + 7] = (byte)value;
    }

    public final float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    public final void putFloat(int index, float value) {
        this.putLong(index, Float.floatToIntBits(value));
    }

    public final double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    public final void putDouble(int index, double value) {
        this.putLong(index, Double.doubleToLongBits(value));
    }
}

