/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.services.iomanager;

import eu.stratosphere.core.memory.MemorySegment;
import eu.stratosphere.nephele.services.iomanager.BlockChannelAccess;
import eu.stratosphere.nephele.services.iomanager.ReadRequest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

final class SegmentReadRequest
implements ReadRequest {
    private final BlockChannelAccess<ReadRequest, ?> channel;
    private final MemorySegment segment;

    protected SegmentReadRequest(BlockChannelAccess<ReadRequest, ?> targetChannel, MemorySegment segment) {
        this.channel = targetChannel;
        this.segment = segment;
    }

    @Override
    public void read() throws IOException {
        FileChannel c = this.channel.fileChannel;
        if (c.size() - c.position() > 0L) {
            try {
                ByteBuffer wrapper = this.segment.wrap(0, this.segment.size());
                this.channel.fileChannel.read(wrapper);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public void requestDone(IOException ioex) {
        this.channel.handleProcessedBuffer(this.segment, ioex);
    }
}

