/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.services.iomanager;

import eu.stratosphere.core.memory.MemorySegment;
import eu.stratosphere.nephele.services.iomanager.BlockChannelReader;
import eu.stratosphere.nephele.services.iomanager.ChannelReaderInputView;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;

public class HeaderlessChannelReaderInputView
extends ChannelReaderInputView {
    private int numBlocksRemaining;
    private final int lastBlockBytes;

    public HeaderlessChannelReaderInputView(BlockChannelReader reader, List<MemorySegment> memory, int numBlocks, int numBytesInLastBlock, boolean waitForFirstBlock) throws IOException {
        super(reader, memory, numBlocks, 0, waitForFirstBlock);
        this.numBlocksRemaining = numBlocks;
        this.lastBlockBytes = numBytesInLastBlock;
    }

    @Override
    protected MemorySegment nextSegment(MemorySegment current) throws IOException {
        if (this.numBlocksRemaining <= 0) {
            this.reader.close();
            throw new EOFException();
        }
        if (current != null) {
            this.sendReadRequest(current);
        }
        --this.numBlocksRemaining;
        return this.reader.getNextReturnedSegment();
    }

    @Override
    protected int getLimitForSegment(MemorySegment segment) {
        return this.numBlocksRemaining > 0 ? segment.size() : this.lastBlockBytes;
    }
}

