/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.services.iomanager;

import eu.stratosphere.nephele.services.iomanager.Channel;
import eu.stratosphere.nephele.services.iomanager.IORequest;
import eu.stratosphere.nephele.services.iomanager.RequestQueue;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;

public abstract class ChannelAccess<T, R extends IORequest> {
    protected final Channel.ID id;
    protected final FileChannel fileChannel;
    protected final RequestQueue<R> requestQueue;
    protected volatile IOException exception;

    protected ChannelAccess(Channel.ID channelID, RequestQueue<R> requestQueue, boolean writeEnabled) throws IOException {
        if (channelID == null || requestQueue == null) {
            throw new NullPointerException();
        }
        this.id = channelID;
        this.requestQueue = requestQueue;
        try {
            RandomAccessFile file = new RandomAccessFile(this.id.getPath(), writeEnabled ? "rw" : "r");
            this.fileChannel = file.getChannel();
        }
        catch (IOException e) {
            throw new IOException("Channel to path '" + channelID.getPath() + "' could not be opened.", e);
        }
    }

    public abstract boolean isClosed();

    protected abstract void returnBuffer(T var1);

    public final Channel.ID getChannelID() {
        return this.id;
    }

    public final void checkErroneous() throws IOException {
        if (this.exception != null) {
            throw new IOException("The channel is erroneous.", this.exception);
        }
    }

    public void deleteChannel() {
        if (this.fileChannel.isOpen()) {
            throw new IllegalStateException("Cannot delete a channel that is open.");
        }
        try {
            File f = new File(this.id.getPath());
            if (f.exists()) {
                f.delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    final void handleProcessedBuffer(T buffer, IOException ex) {
        if (ex != null && this.exception == null) {
            this.exception = ex;
        }
        this.returnBuffer(buffer);
    }
}

