/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.services.iomanager;

import eu.stratosphere.util.StringUtils;
import java.io.File;
import java.util.Random;

public final class Channel {
    private static final int RANDOM_BYTES_LENGTH = 16;

    private static final String randomString(Random random) {
        byte[] bytes = new byte[16];
        random.nextBytes(bytes);
        return StringUtils.byteToHexString((byte[])bytes);
    }

    public static final class Enumerator {
        private static final String FORMAT = "%s%s%s.%06d.channel";
        private final String[] paths;
        private final String namePrefix;
        private int counter;

        protected Enumerator(String[] basePaths, Random random) {
            this.paths = basePaths;
            this.namePrefix = Channel.randomString(random);
            this.counter = 0;
        }

        public ID next() {
            int threadNum = this.counter % this.paths.length;
            return new ID(String.format(FORMAT, this.paths[threadNum], File.separator, this.namePrefix, this.counter++), threadNum);
        }
    }

    public static class ID {
        private final String path;
        private final int threadNum;

        protected ID(String path, int threadNum) {
            this.path = path;
            this.threadNum = threadNum;
        }

        protected ID(String basePath, int threadNum, Random random) {
            this.path = basePath + File.separator + Channel.randomString(random) + ".channel";
            this.threadNum = threadNum;
        }

        public String getPath() {
            return this.path;
        }

        int getThreadNum() {
            return this.threadNum;
        }

        public String toString() {
            return this.path;
        }
    }
}

