/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.services.iomanager;

import eu.stratosphere.core.memory.MemorySegment;
import eu.stratosphere.nephele.services.iomanager.BlockChannelAccess;
import eu.stratosphere.nephele.services.iomanager.Channel;
import eu.stratosphere.nephele.services.iomanager.ReadRequest;
import eu.stratosphere.nephele.services.iomanager.RequestQueue;
import eu.stratosphere.nephele.services.iomanager.SegmentReadRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BulkBlockChannelReader
extends BlockChannelAccess<ReadRequest, ArrayList<MemorySegment>> {
    protected BulkBlockChannelReader(Channel.ID channelID, RequestQueue<ReadRequest> requestQueue, List<MemorySegment> sourceSegments, int numBlocks) throws IOException {
        super(channelID, requestQueue, new ArrayList(numBlocks), false);
        if (sourceSegments.size() < numBlocks) {
            throw new IllegalArgumentException("The list of source memory segments must contain at least as many segments as the number of blocks to read.");
        }
        for (int i = 0; i < numBlocks; ++i) {
            this.readBlock(sourceSegments.remove(sourceSegments.size() - 1));
        }
    }

    private void readBlock(MemorySegment segment) throws IOException {
        this.checkErroneous();
        this.requestsNotReturned.incrementAndGet();
        if (this.closed || this.requestQueue.isClosed()) {
            this.requestsNotReturned.decrementAndGet();
            throw new IOException("The reader has been closed.");
        }
        this.requestQueue.add(new SegmentReadRequest(this, segment));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MemorySegment> getFullSegments() {
        Object object = this.closeLock;
        synchronized (object) {
            if (!this.isClosed() || this.requestsNotReturned.get() > 0) {
                throw new IllegalStateException("Full segments can only be obtained after the reader was properly closed.");
            }
        }
        return (List)this.returnBuffers;
    }
}

