/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.services.iomanager;

import eu.stratosphere.core.memory.MemorySegment;
import eu.stratosphere.nephele.services.iomanager.BlockChannelAccess;
import eu.stratosphere.nephele.services.iomanager.Channel;
import eu.stratosphere.nephele.services.iomanager.RequestQueue;
import eu.stratosphere.nephele.services.iomanager.SegmentWriteRequest;
import eu.stratosphere.nephele.services.iomanager.WriteRequest;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class BlockChannelWriter
extends BlockChannelAccess<WriteRequest, LinkedBlockingQueue<MemorySegment>> {
    protected BlockChannelWriter(Channel.ID channelID, RequestQueue<WriteRequest> requestQueue, LinkedBlockingQueue<MemorySegment> returnSegments, int numRequestsToBundle) throws IOException {
        super(channelID, requestQueue, returnSegments, true);
    }

    public void writeBlock(MemorySegment segment) throws IOException {
        this.checkErroneous();
        this.requestsNotReturned.incrementAndGet();
        if (this.closed || this.requestQueue.isClosed()) {
            this.requestsNotReturned.decrementAndGet();
            throw new IOException("The writer has been closed.");
        }
        this.requestQueue.add(new SegmentWriteRequest(this, segment));
    }

    public MemorySegment getNextReturnedSegment() throws IOException {
        try {
            while (true) {
                MemorySegment next;
                if ((next = (MemorySegment)((LinkedBlockingQueue)this.returnBuffers).poll(2000L, TimeUnit.MILLISECONDS)) != null) {
                    return next;
                }
                if (this.closed) {
                    throw new IOException("The writer has been closed.");
                }
                this.checkErroneous();
            }
        }
        catch (InterruptedException iex) {
            throw new IOException("Writer was interrupted while waiting for the next returning segment.");
        }
    }
}

