/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.services.iomanager;

import eu.stratosphere.core.memory.MemorySegment;
import eu.stratosphere.nephele.services.iomanager.BlockChannelAccess;
import eu.stratosphere.nephele.services.iomanager.Channel;
import eu.stratosphere.nephele.services.iomanager.ReadRequest;
import eu.stratosphere.nephele.services.iomanager.RequestQueue;
import eu.stratosphere.nephele.services.iomanager.SegmentReadRequest;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class BlockChannelReader
extends BlockChannelAccess<ReadRequest, LinkedBlockingQueue<MemorySegment>> {
    protected BlockChannelReader(Channel.ID channelID, RequestQueue<ReadRequest> requestQueue, LinkedBlockingQueue<MemorySegment> returnSegments, int numRequestsToBundle) throws IOException {
        super(channelID, requestQueue, returnSegments, false);
    }

    public void readBlock(MemorySegment segment) throws IOException {
        this.checkErroneous();
        this.requestsNotReturned.incrementAndGet();
        if (this.closed || this.requestQueue.isClosed()) {
            this.requestsNotReturned.decrementAndGet();
            throw new IOException("The reader has been closed.");
        }
        this.requestQueue.add(new SegmentReadRequest(this, segment));
    }

    public MemorySegment getNextReturnedSegment() throws IOException {
        try {
            while (true) {
                MemorySegment next;
                if ((next = (MemorySegment)((LinkedBlockingQueue)this.returnBuffers).poll(2000L, TimeUnit.MILLISECONDS)) != null) {
                    return next;
                }
                if (this.closed) {
                    throw new IOException("The reader has been asynchronously closed.");
                }
                this.checkErroneous();
            }
        }
        catch (InterruptedException iex) {
            throw new IOException("Reader was interrupted while waiting for the next returning segment.");
        }
    }
}

