/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.services.accumulators;

import eu.stratosphere.api.common.accumulators.Accumulator;
import eu.stratosphere.core.io.IOReadableWritable;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.nephele.execution.librarycache.LibraryCacheManager;
import eu.stratosphere.nephele.jobgraph.JobID;
import eu.stratosphere.util.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AccumulatorEvent
implements IOReadableWritable {
    private JobID jobID;
    private Map<String, Accumulator<?, ?>> accumulators = new HashMap();
    private boolean useUserClassLoader = false;

    public AccumulatorEvent() {
    }

    public AccumulatorEvent(JobID jobID, Map<String, Accumulator<?, ?>> accumulators, boolean useUserClassLoader) {
        this.accumulators = accumulators;
        this.jobID = jobID;
        this.useUserClassLoader = useUserClassLoader;
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public Map<String, Accumulator<?, ?>> getAccumulators() {
        return this.accumulators;
    }

    public void write(DataOutputView out) throws IOException {
        out.writeBoolean(this.useUserClassLoader);
        this.jobID.write(out);
        out.writeInt(this.accumulators.size());
        for (Map.Entry<String, Accumulator<?, ?>> entry : this.accumulators.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeUTF(entry.getValue().getClass().getName());
            entry.getValue().write(out);
        }
    }

    public void read(DataInputView in) throws IOException {
        this.useUserClassLoader = in.readBoolean();
        this.jobID = new JobID();
        this.jobID.read(in);
        int numberOfMapEntries = in.readInt();
        this.accumulators = new HashMap(numberOfMapEntries);
        ClassLoader classLoader = null;
        classLoader = this.useUserClassLoader ? LibraryCacheManager.getClassLoader(this.jobID) : this.getClass().getClassLoader();
        for (int i = 0; i < numberOfMapEntries; ++i) {
            String key = in.readUTF();
            String valueType = in.readUTF();
            Class<?> valueClass = null;
            try {
                valueClass = Class.forName(valueType, true, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            Accumulator value = null;
            try {
                value = (Accumulator)valueClass.newInstance();
            }
            catch (Exception e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            value.read(in);
            this.accumulators.put(key, value);
        }
    }
}

