/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.profiling.types;

import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.nephele.jobgraph.JobID;
import eu.stratosphere.nephele.managementgraph.ManagementVertexID;
import eu.stratosphere.nephele.profiling.types.ProfilingEvent;
import java.io.IOException;

public abstract class VertexProfilingEvent
extends ProfilingEvent {
    private ManagementVertexID vertexID;
    private int profilingInterval;

    public VertexProfilingEvent(ManagementVertexID vertexID, int profilingInterval, JobID jobID, long timestamp, long profilingTimestamp) {
        super(jobID, timestamp, profilingTimestamp);
        this.vertexID = vertexID;
        this.profilingInterval = profilingInterval;
    }

    public VertexProfilingEvent() {
    }

    public ManagementVertexID getVertexID() {
        return this.vertexID;
    }

    public int getProfilingInterval() {
        return this.profilingInterval;
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        this.vertexID = new ManagementVertexID();
        this.vertexID.read(in);
        this.profilingInterval = in.readInt();
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        this.vertexID.write(out);
        out.writeInt(this.profilingInterval);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof VertexProfilingEvent)) {
            return false;
        }
        VertexProfilingEvent vertexProfilingEvent = (VertexProfilingEvent)obj;
        if (!this.vertexID.equals(vertexProfilingEvent.getVertexID())) {
            return false;
        }
        return this.profilingInterval == vertexProfilingEvent.getProfilingInterval();
    }
}

