/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.profiling.types;

import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.nephele.jobgraph.JobID;
import eu.stratosphere.nephele.managementgraph.ManagementVertexID;
import eu.stratosphere.nephele.profiling.types.VertexProfilingEvent;
import java.io.IOException;

public class ThreadProfilingEvent
extends VertexProfilingEvent {
    private int userTime;
    private int systemTime;
    private int blockedTime;
    private int waitedTime;

    public ThreadProfilingEvent(int userTime, int systemTime, int blockedTime, int waitedTime, ManagementVertexID vertexID, int profilingInterval, JobID jobID, long timestamp, long profilingTimestamp) {
        super(vertexID, profilingInterval, jobID, timestamp, profilingTimestamp);
        this.userTime = userTime;
        this.systemTime = systemTime;
        this.blockedTime = blockedTime;
        this.waitedTime = waitedTime;
    }

    public ThreadProfilingEvent() {
    }

    public int getUserTime() {
        return this.userTime;
    }

    public int getSystemTime() {
        return this.systemTime;
    }

    public int getBlockedTime() {
        return this.blockedTime;
    }

    public int getWaitedTime() {
        return this.waitedTime;
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        this.userTime = in.readInt();
        this.systemTime = in.readInt();
        this.blockedTime = in.readInt();
        this.waitedTime = in.readInt();
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        out.writeInt(this.userTime);
        out.writeInt(this.systemTime);
        out.writeInt(this.blockedTime);
        out.writeInt(this.waitedTime);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ThreadProfilingEvent)) {
            return false;
        }
        ThreadProfilingEvent threadProfilingEvent = (ThreadProfilingEvent)obj;
        if (this.userTime != threadProfilingEvent.getUserTime()) {
            return false;
        }
        if (this.systemTime != threadProfilingEvent.getSystemTime()) {
            return false;
        }
        if (this.blockedTime != threadProfilingEvent.getBlockedTime()) {
            return false;
        }
        return this.waitedTime == threadProfilingEvent.getWaitedTime();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

