/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.profiling.types;

import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.nephele.event.job.AbstractEvent;
import eu.stratosphere.nephele.event.job.ManagementEvent;
import eu.stratosphere.nephele.jobgraph.JobID;
import java.io.IOException;

public abstract class ProfilingEvent
extends AbstractEvent
implements ManagementEvent {
    private JobID jobID;
    private long profilingTimestamp;

    public ProfilingEvent(JobID jobID, long timestamp, long profilingTimestamp) {
        super(timestamp);
        this.jobID = jobID;
        this.profilingTimestamp = profilingTimestamp;
    }

    public ProfilingEvent() {
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public long getProfilingTimestamp() {
        return this.profilingTimestamp;
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        this.jobID = new JobID();
        this.jobID.read(in);
        this.profilingTimestamp = in.readLong();
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        this.jobID.write(out);
        out.writeLong(this.profilingTimestamp);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ProfilingEvent)) {
            return false;
        }
        ProfilingEvent profilingEvent = (ProfilingEvent)obj;
        if (!this.jobID.equals(profilingEvent.getJobID())) {
            return false;
        }
        return this.profilingTimestamp == profilingEvent.getProfilingTimestamp();
    }

    @Override
    public int hashCode() {
        if (this.jobID != null) {
            return this.jobID.hashCode();
        }
        return super.hashCode();
    }
}

