/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.profiling.impl.types;

import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.nephele.executiongraph.ExecutionVertexID;
import eu.stratosphere.nephele.jobgraph.JobID;
import eu.stratosphere.nephele.profiling.impl.types.InternalProfilingData;
import java.io.IOException;

public class InternalInputGateProfilingData
implements InternalProfilingData {
    private final ExecutionVertexID executionVertexID;
    private final JobID jobId;
    private int gateIndex;
    private int profilingInternval;
    private int noRecordsAvailableCounter;

    public InternalInputGateProfilingData() {
        this.jobId = new JobID();
        this.executionVertexID = new ExecutionVertexID();
        this.gateIndex = 0;
        this.profilingInternval = 0;
        this.noRecordsAvailableCounter = 0;
    }

    public InternalInputGateProfilingData(JobID jobID, ExecutionVertexID executionVertexID, int gateIndex, int profilingInterval, int noRecordsAvailableCounter) {
        this.jobId = jobID;
        this.executionVertexID = executionVertexID;
        this.gateIndex = gateIndex;
        this.profilingInternval = profilingInterval;
        this.noRecordsAvailableCounter = noRecordsAvailableCounter;
    }

    public void read(DataInputView in) throws IOException {
        this.jobId.read(in);
        this.executionVertexID.read(in);
        this.gateIndex = in.readInt();
        this.profilingInternval = in.readInt();
        this.noRecordsAvailableCounter = in.readInt();
    }

    public void write(DataOutputView out) throws IOException {
        this.jobId.write(out);
        this.executionVertexID.write(out);
        out.writeInt(this.gateIndex);
        out.writeInt(this.profilingInternval);
        out.writeInt(this.noRecordsAvailableCounter);
    }

    public JobID getJobID() {
        return this.jobId;
    }

    public ExecutionVertexID getExecutionVertexID() {
        return this.executionVertexID;
    }

    public int getGateIndex() {
        return this.gateIndex;
    }

    public int getProfilingInterval() {
        return this.profilingInternval;
    }

    public int getNoRecordsAvailableCounter() {
        return this.noRecordsAvailableCounter;
    }
}

