/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.profiling.impl.types;

import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.nephele.executiongraph.ExecutionVertexID;
import eu.stratosphere.nephele.jobgraph.JobID;
import eu.stratosphere.nephele.profiling.impl.types.InternalExecutionVertexProfilingData;
import java.io.IOException;

public class InternalExecutionVertexThreadProfilingData
extends InternalExecutionVertexProfilingData {
    private int profilingInterval = 0;
    private int userTime = 0;
    private int systemTime = 0;
    private int blockedTime = 0;
    private int waitedTime = 0;

    public InternalExecutionVertexThreadProfilingData(JobID jobID, ExecutionVertexID executionVertexID, int profilingInterval, int userTime, int systemTime, int blockedTime, int waitedTime) {
        super(jobID, executionVertexID);
        this.profilingInterval = profilingInterval;
        this.userTime = userTime;
        this.systemTime = systemTime;
        this.blockedTime = blockedTime;
        this.waitedTime = waitedTime;
    }

    public InternalExecutionVertexThreadProfilingData() {
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        this.profilingInterval = in.readInt();
        this.userTime = in.readInt();
        this.systemTime = in.readInt();
        this.blockedTime = in.readInt();
        this.waitedTime = in.readInt();
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        out.writeInt(this.profilingInterval);
        out.writeInt(this.userTime);
        out.writeInt(this.systemTime);
        out.writeInt(this.blockedTime);
        out.writeInt(this.waitedTime);
    }

    public int getBlockedTime() {
        return this.blockedTime;
    }

    public int getProfilingInterval() {
        return this.profilingInterval;
    }

    public int getSystemTime() {
        return this.systemTime;
    }

    public int getUserTime() {
        return this.userTime;
    }

    public int getWaitedTime() {
        return this.waitedTime;
    }
}

