/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.profiling.impl;

import eu.stratosphere.nephele.execution.ExecutionListener;
import eu.stratosphere.nephele.execution.ExecutionState;
import eu.stratosphere.nephele.execution.RuntimeEnvironment;
import eu.stratosphere.nephele.executiongraph.ExecutionVertexID;
import eu.stratosphere.nephele.jobgraph.JobID;
import eu.stratosphere.nephele.profiling.impl.TaskManagerProfilerImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EnvironmentListenerImpl
implements ExecutionListener {
    private static final Log LOG = LogFactory.getLog(EnvironmentListenerImpl.class);
    private final TaskManagerProfilerImpl taskManagerProfiler;
    private final RuntimeEnvironment environment;

    public EnvironmentListenerImpl(TaskManagerProfilerImpl taskManagerProfiler, RuntimeEnvironment environment) {
        this.taskManagerProfiler = taskManagerProfiler;
        this.environment = environment;
    }

    @Override
    public void executionStateChanged(JobID jobID, ExecutionVertexID vertexID, ExecutionState newExecutionState, String optionalMessage) {
        switch (newExecutionState) {
            case RUNNING: {
                this.taskManagerProfiler.registerMainThreadForCPUProfiling(this.environment, this.environment.getExecutingThread(), vertexID);
                break;
            }
            case FINISHING: 
            case FINISHED: 
            case CANCELING: 
            case CANCELED: 
            case FAILED: {
                this.taskManagerProfiler.unregisterMainThreadFromCPUProfiling(this.environment, this.environment.getExecutingThread());
                break;
            }
            default: {
                LOG.error((Object)("Unexpected state transition to " + (Object)((Object)newExecutionState) + " for vertex " + vertexID));
            }
        }
    }

    @Override
    public void userThreadFinished(JobID jobID, ExecutionVertexID vertexID, Thread userThread) {
        if (this.environment.getExecutingThread() == userThread) {
            return;
        }
        this.taskManagerProfiler.unregisterUserThreadFromCPUProfiling(this.environment, userThread);
    }

    @Override
    public void userThreadStarted(JobID jobID, ExecutionVertexID vertexID, Thread userThread) {
        if (this.environment.getExecutingThread() == userThread) {
            return;
        }
        this.taskManagerProfiler.registerUserThreadForCPUProfiling(this.environment, userThread);
    }

    @Override
    public int getPriority() {
        return 1;
    }
}

