/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.profiling;

import eu.stratosphere.nephele.instance.InstanceConnectionInfo;
import eu.stratosphere.nephele.profiling.JobManagerProfiler;
import eu.stratosphere.nephele.profiling.TaskManagerProfiler;
import eu.stratosphere.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProfilingUtils {
    private static final Log LOG = LogFactory.getLog(ProfilingUtils.class);
    public static final String ENABLE_PROFILING_KEY = "jobmanager.profiling.enable";
    public static final String JOBMANAGER_CLASSNAME_KEY = "jobmanager.profiling.classname";
    public static final String TASKMANAGER_CLASSNAME_KEY = "taskmanager.profiling.classname";
    public static final String PROFILE_JOB_KEY = "job.profiling.enable";
    public static final String JOBMANAGER_RPC_PORT_KEY = "jobmanager.profiling.rpc.port";
    public static final int JOBMANAGER_DEFAULT_RPC_PORT = 6124;
    public static final String TASKMANAGER_REPORTINTERVAL_KEY = "taskmanager.profiling.reportinterval";
    public static final int DEFAULT_TASKMANAGER_REPORTINTERVAL = 2;

    public static JobManagerProfiler loadJobManagerProfiler(String profilerClassName, InetAddress jobManagerBindAddress) {
        Class<?> profilerClass;
        try {
            profilerClass = Class.forName(profilerClassName);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("Cannot find class " + profilerClassName + ": " + StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        JobManagerProfiler profiler = null;
        try {
            Constructor<?> constr = profilerClass.getConstructor(InetAddress.class);
            profiler = (JobManagerProfiler)constr.newInstance(jobManagerBindAddress);
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)("Cannot create profiler: " + StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)("Cannot create profiler: " + StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        catch (InstantiationException e) {
            LOG.error((Object)("Cannot create profiler: " + StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)("Cannot create profiler: " + StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("Cannot create profiler: " + StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        return profiler;
    }

    public static TaskManagerProfiler loadTaskManagerProfiler(String profilerClassName, InetAddress jobManagerAddress, InstanceConnectionInfo instanceConnectionInfo) {
        Class<?> profilerClass;
        try {
            profilerClass = Class.forName(profilerClassName);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("Cannot find class " + profilerClassName + ": " + StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        Constructor<?> constructor = null;
        try {
            constructor = profilerClass.getConstructor(InetAddress.class, InstanceConnectionInfo.class);
        }
        catch (SecurityException e1) {
            LOG.error((Object)e1);
            return null;
        }
        catch (NoSuchMethodException e1) {
            LOG.error((Object)e1);
            return null;
        }
        TaskManagerProfiler profiler = null;
        try {
            profiler = (TaskManagerProfiler)constructor.newInstance(jobManagerAddress, instanceConnectionInfo);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)e);
        }
        catch (InstantiationException e) {
            LOG.error((Object)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)e);
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)e);
        }
        return profiler;
    }
}

