/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.net;

import eu.stratosphere.nephele.ipc.Server;
import eu.stratosphere.nephele.net.SocketIOWithTimeout;
import eu.stratosphere.nephele.net.SocketInputStream;
import eu.stratosphere.nephele.net.SocketOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NetUtils {
    private static final Log LOG = LogFactory.getLog(NetUtils.class);
    private static Map<String, String> hostToResolved = new HashMap<String, String>();

    public static SocketFactory getSocketFactory() {
        return NetUtils.getDefaultSocketFactory();
    }

    public static SocketFactory getDefaultSocketFactory() {
        return SocketFactory.getDefault();
    }

    public static InetSocketAddress createSocketAddr(String target) {
        return NetUtils.createSocketAddr(target, -1);
    }

    public static InetSocketAddress createSocketAddr(String target, int defaultPort) {
        int colonIndex = target.indexOf(58);
        if (colonIndex < 0 && defaultPort == -1) {
            throw new RuntimeException("Not a host:port pair: " + target);
        }
        String hostname = "";
        int port = -1;
        if (!target.contains("/")) {
            if (colonIndex == -1) {
                hostname = target;
            } else {
                hostname = target.substring(0, colonIndex);
                port = Integer.parseInt(target.substring(colonIndex + 1));
            }
        } else {
            try {
                URI addr = new URI(target);
                hostname = addr.getHost();
                port = addr.getPort();
            }
            catch (URISyntaxException use) {
                LOG.fatal((Object)use);
            }
        }
        if (port == -1) {
            port = defaultPort;
        }
        if (NetUtils.getStaticResolution(hostname) != null) {
            hostname = NetUtils.getStaticResolution(hostname);
        }
        return new InetSocketAddress(hostname, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStaticResolution(String host, String resolvedName) {
        Map<String, String> map = hostToResolved;
        synchronized (map) {
            hostToResolved.put(host, resolvedName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStaticResolution(String host) {
        Map<String, String> map = hostToResolved;
        synchronized (map) {
            return hostToResolved.get(host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String[]> getAllStaticResolutions() {
        Map<String, String> map = hostToResolved;
        synchronized (map) {
            Set<Map.Entry<String, String>> entries = hostToResolved.entrySet();
            if (entries.size() == 0) {
                return null;
            }
            ArrayList<String[]> l = new ArrayList<String[]>(entries.size());
            for (Map.Entry<String, String> e : entries) {
                l.add(new String[]{e.getKey(), e.getValue()});
            }
            return l;
        }
    }

    public static InetSocketAddress getConnectAddress(Server server) {
        InetSocketAddress addr = server.getListenerAddress();
        if (addr.getAddress().getHostAddress().equals("0.0.0.0")) {
            addr = new InetSocketAddress("127.0.0.1", addr.getPort());
        }
        return addr;
    }

    public static InputStream getInputStream(Socket socket) throws IOException {
        return NetUtils.getInputStream(socket, socket.getSoTimeout());
    }

    public static InputStream getInputStream(Socket socket, long timeout) throws IOException {
        return socket.getChannel() == null ? socket.getInputStream() : new SocketInputStream(socket, timeout);
    }

    public static OutputStream getOutputStream(Socket socket) throws IOException {
        return NetUtils.getOutputStream(socket, 0L);
    }

    public static OutputStream getOutputStream(Socket socket, long timeout) throws IOException {
        return socket.getChannel() == null ? socket.getOutputStream() : new SocketOutputStream(socket, timeout);
    }

    public static void connect(Socket socket, SocketAddress endpoint, int timeout) throws IOException {
        if (socket == null || endpoint == null || timeout < 0) {
            throw new IllegalArgumentException("Illegal argument for connect()");
        }
        SocketChannel ch = socket.getChannel();
        if (ch == null) {
            socket.connect(endpoint, timeout);
        } else {
            SocketIOWithTimeout.connect(ch, endpoint, timeout);
        }
    }

    public static String normalizeHostName(String name) {
        if (Character.digit(name.charAt(0), 16) != -1) {
            return name;
        }
        try {
            InetAddress ipAddress = InetAddress.getByName(name);
            return ipAddress.getHostAddress();
        }
        catch (UnknownHostException e) {
            return name;
        }
    }

    public static List<String> normalizeHostNames(Collection<String> names) {
        ArrayList<String> hostNames = new ArrayList<String>(names.size());
        for (String name : names) {
            hostNames.add(NetUtils.normalizeHostName(name));
        }
        return hostNames;
    }
}

