/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.managementgraph;

import eu.stratosphere.nephele.managementgraph.ManagementAttachment;
import eu.stratosphere.nephele.managementgraph.ManagementGraph;
import eu.stratosphere.nephele.managementgraph.ManagementGroupVertex;
import eu.stratosphere.nephele.managementgraph.ManagementVertex;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ManagementStage
extends ManagementAttachment {
    private final ManagementGraph managementGraph;
    private int stageNumber = -1;
    private final List<ManagementGroupVertex> groupVertices = new ArrayList<ManagementGroupVertex>();

    public ManagementStage(ManagementGraph managementGraph, int stageNumber) {
        this.managementGraph = managementGraph;
        this.stageNumber = stageNumber;
        this.managementGraph.addStage(this);
    }

    public ManagementGraph getGraph() {
        return this.managementGraph;
    }

    public int getStageNumber() {
        return this.stageNumber;
    }

    public int getNumberOfGroupVertices() {
        return this.groupVertices.size();
    }

    public ManagementGroupVertex getGroupVertex(int index) {
        if (index < this.groupVertices.size()) {
            return this.groupVertices.get(index);
        }
        return null;
    }

    void addGroupVertex(ManagementGroupVertex groupVertex) {
        this.groupVertices.add(groupVertex);
        this.managementGraph.addGroupVertex(groupVertex.getID(), groupVertex);
    }

    void collectGroupVertices(List<ManagementGroupVertex> groupVertices) {
        Iterator<ManagementGroupVertex> it = this.groupVertices.iterator();
        while (it.hasNext()) {
            groupVertices.add(it.next());
        }
    }

    void collectVertices(List<ManagementVertex> vertices) {
        Iterator<ManagementGroupVertex> it = this.groupVertices.iterator();
        while (it.hasNext()) {
            it.next().collectVertices(vertices);
        }
    }

    public int getNumberOfInputManagementVertices() {
        int retVal = 0;
        for (ManagementGroupVertex groupVertex : this.groupVertices) {
            if (!groupVertex.isInputVertex()) continue;
            retVal += groupVertex.getNumberOfGroupMembers();
        }
        return retVal;
    }

    public int getNumberOfOutputManagementVertices() {
        int retVal = 0;
        for (ManagementGroupVertex groupVertex : this.groupVertices) {
            if (!groupVertex.isOutputVertex()) continue;
            retVal += groupVertex.getNumberOfGroupMembers();
        }
        return retVal;
    }

    public ManagementVertex getInputManagementVertex(int index) {
        for (ManagementGroupVertex groupVertex : this.groupVertices) {
            if (!groupVertex.isInputVertex()) continue;
            int numberOfMembers = groupVertex.getNumberOfGroupMembers();
            if (index >= numberOfMembers) {
                index -= numberOfMembers;
                continue;
            }
            return groupVertex.getGroupMember(index);
        }
        return null;
    }

    public ManagementVertex getOutputManagementVertex(int index) {
        for (ManagementGroupVertex groupVertex : this.groupVertices) {
            if (!groupVertex.isOutputVertex()) continue;
            int numberOfMembers = groupVertex.getNumberOfGroupMembers();
            if (index >= numberOfMembers) {
                index -= numberOfMembers;
                continue;
            }
            return groupVertex.getGroupMember(index);
        }
        return null;
    }

    public int getNumberOfInputGroupVertices() {
        int retVal = 0;
        Iterator<ManagementGroupVertex> it = this.groupVertices.iterator();
        while (it.hasNext()) {
            if (!it.next().isInputVertex()) continue;
            ++retVal;
        }
        return retVal;
    }

    public ManagementGroupVertex getInputGroupVertex(int index) {
        for (ManagementGroupVertex groupVertex : this.groupVertices) {
            if (!groupVertex.isInputVertex()) continue;
            if (index == 0) {
                return groupVertex;
            }
            --index;
        }
        return null;
    }

    public int getNumberOfOutputGroupVertices() {
        int retVal = 0;
        Iterator<ManagementGroupVertex> it = this.groupVertices.iterator();
        while (it.hasNext()) {
            if (!it.next().isOutputVertex()) continue;
            ++retVal;
        }
        return retVal;
    }

    public ManagementGroupVertex getOutputGroupVertex(int index) {
        for (ManagementGroupVertex groupVertex : this.groupVertices) {
            if (!groupVertex.isOutputVertex()) continue;
            if (index == 0) {
                return groupVertex;
            }
            --index;
        }
        return null;
    }
}

