/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.managementgraph;

import eu.stratosphere.nephele.managementgraph.ManagementGraph;
import eu.stratosphere.nephele.managementgraph.ManagementGroupVertex;
import eu.stratosphere.nephele.managementgraph.ManagementStage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public final class ManagementGroupVertexIterator
implements Iterator<ManagementGroupVertex> {
    private final boolean forward;
    private final int stage;
    private final List<ManagementGroupVertex> entryVertices = new ArrayList<ManagementGroupVertex>();
    private int numVisitedEntryVertices = 0;
    private final Stack<TraversalEntry> traversalStack = new Stack();
    private final Set<ManagementGroupVertex> alreadyVisited = new HashSet<ManagementGroupVertex>();

    public ManagementGroupVertexIterator(ManagementGraph managementGraph, boolean forward, int stage) {
        this.forward = forward;
        this.stage = stage;
        if (stage < 0) {
            for (int i = 0; i < managementGraph.getNumberOfStages(); ++i) {
                this.collectStartVertices(managementGraph.getStage(i));
            }
        } else if (stage < managementGraph.getNumberOfStages()) {
            this.collectStartVertices(managementGraph.getStage(stage));
        }
        if (this.entryVertices.size() > 0) {
            TraversalEntry te = new TraversalEntry(this.entryVertices.get(0), 0);
            this.traversalStack.push(te);
            this.alreadyVisited.add(te.getGroupVertex());
        }
    }

    private void collectStartVertices(ManagementStage stage) {
        for (int i = 0; i < stage.getNumberOfGroupVertices(); ++i) {
            ManagementGroupVertex groupVertex = stage.getGroupVertex(i);
            if (this.forward) {
                if (groupVertex.getNumberOfBackwardEdges() != 0 && (this.stage < 0 || !this.allConnectionsFromOtherStage(groupVertex, true))) continue;
                this.entryVertices.add(groupVertex);
                continue;
            }
            if (groupVertex.getNumberOfForwardEdges() != 0 && (this.stage < 0 || !this.allConnectionsFromOtherStage(groupVertex, false))) continue;
            this.entryVertices.add(groupVertex);
        }
    }

    private boolean allConnectionsFromOtherStage(ManagementGroupVertex groupVertex, boolean forward) {
        if (forward) {
            for (int i = 0; i < groupVertex.getNumberOfBackwardEdges(); ++i) {
                if (this.stage != groupVertex.getBackwardEdge(i).getSource().getStageNumber()) continue;
                return false;
            }
        } else {
            for (int i = 0; i < groupVertex.getNumberOfForwardEdges(); ++i) {
                if (this.stage != groupVertex.getForwardEdge(i).getTarget().getStageNumber()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        if (this.traversalStack.isEmpty()) {
            ++this.numVisitedEntryVertices;
            if (this.entryVertices.size() <= this.numVisitedEntryVertices) {
                return false;
            }
        }
        return true;
    }

    @Override
    public ManagementGroupVertex next() {
        if (this.traversalStack.isEmpty()) {
            TraversalEntry newentry = new TraversalEntry(this.entryVertices.get(this.numVisitedEntryVertices), 0);
            this.traversalStack.push(newentry);
            this.alreadyVisited.add(newentry.getGroupVertex());
        }
        ManagementGroupVertex returnVertex = this.traversalStack.peek().getGroupVertex();
        do {
            TraversalEntry te;
            ManagementGroupVertex candidateVertex;
            if ((candidateVertex = this.getCandidateVertex(te = this.traversalStack.peek(), this.forward)) != null) {
                TraversalEntry newte = new TraversalEntry(candidateVertex, 0);
                this.traversalStack.push(newte);
                this.alreadyVisited.add(newte.getGroupVertex());
                break;
            }
            this.traversalStack.pop();
        } while (!this.traversalStack.isEmpty());
        return returnVertex;
    }

    private ManagementGroupVertex getCandidateVertex(TraversalEntry te, boolean forward) {
        while (!(forward ? te.getCurrentEdge() >= te.getGroupVertex().getNumberOfForwardEdges() : te.getCurrentEdge() >= te.getGroupVertex().getNumberOfBackwardEdges())) {
            ManagementGroupVertex tmp = null;
            tmp = forward ? te.getGroupVertex().getForwardEdge(te.getCurrentEdge()).getTarget() : te.getGroupVertex().getBackwardEdge(te.getCurrentEdge()).getSource();
            te.increaseCurrentEdge();
            if (this.stage >= 0 && tmp.getStageNumber() != this.stage || this.alreadyVisited.contains(tmp)) continue;
            return tmp;
        }
        return null;
    }

    @Override
    public void remove() {
    }

    private static class TraversalEntry {
        private final ManagementGroupVertex groupVertex;
        private int currentEdge = 0;

        public TraversalEntry(ManagementGroupVertex groupVertex, int currentEdge) {
            this.groupVertex = groupVertex;
            this.currentEdge = currentEdge;
        }

        public ManagementGroupVertex getGroupVertex() {
            return this.groupVertex;
        }

        public int getCurrentEdge() {
            return this.currentEdge;
        }

        public void increaseCurrentEdge() {
            ++this.currentEdge;
        }
    }
}

