/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.managementgraph;

import eu.stratosphere.core.io.IOReadableWritable;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.nephele.execution.ExecutionState;
import eu.stratosphere.nephele.managementgraph.ManagementAttachment;
import eu.stratosphere.nephele.managementgraph.ManagementGraph;
import eu.stratosphere.nephele.managementgraph.ManagementGroupEdge;
import eu.stratosphere.nephele.managementgraph.ManagementGroupVertexID;
import eu.stratosphere.nephele.managementgraph.ManagementStage;
import eu.stratosphere.nephele.managementgraph.ManagementVertex;
import eu.stratosphere.nephele.util.EnumUtils;
import eu.stratosphere.runtime.io.channels.ChannelType;
import eu.stratosphere.util.StringUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ManagementGroupVertex
extends ManagementAttachment
implements IOReadableWritable {
    private final ManagementGroupVertexID id;
    private final String name;
    private final ManagementStage stage;
    private final List<ManagementVertex> groupMembers = new ArrayList<ManagementVertex>();
    private final List<ManagementGroupEdge> forwardEdges = new ArrayList<ManagementGroupEdge>();
    private final List<ManagementGroupEdge> backwardEdges = new ArrayList<ManagementGroupEdge>();

    public ManagementGroupVertex(ManagementStage stage, String name) {
        this(stage, new ManagementGroupVertexID(), name);
    }

    public ManagementGroupVertex(ManagementStage stage, ManagementGroupVertexID id, String name) {
        this.stage = stage;
        this.id = id;
        this.name = name;
        stage.addGroupVertex(this);
    }

    public ManagementGroupVertexID getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    void insertForwardEdge(ManagementGroupEdge edge, int index) {
        while (index >= this.forwardEdges.size()) {
            this.forwardEdges.add(null);
        }
        this.forwardEdges.set(index, edge);
    }

    void insertBackwardEdge(ManagementGroupEdge edge, int index) {
        while (index >= this.backwardEdges.size()) {
            this.backwardEdges.add(null);
        }
        this.backwardEdges.set(index, edge);
    }

    public int getNumberOfForwardEdges() {
        return this.forwardEdges.size();
    }

    public int getNumberOfBackwardEdges() {
        return this.backwardEdges.size();
    }

    public ManagementGroupEdge getForwardEdge(int index) {
        if (index < this.forwardEdges.size()) {
            return this.forwardEdges.get(index);
        }
        return null;
    }

    public ManagementGroupEdge getBackwardEdge(int index) {
        if (index < this.backwardEdges.size()) {
            return this.backwardEdges.get(index);
        }
        return null;
    }

    void addGroupMember(ManagementVertex vertex) {
        while (this.groupMembers.size() <= vertex.getIndexInGroup()) {
            this.groupMembers.add(null);
        }
        this.groupMembers.set(vertex.getIndexInGroup(), vertex);
        this.getGraph().addVertex(vertex.getID(), vertex);
    }

    void collectVertices(List<ManagementVertex> vertices) {
        Iterator<ManagementVertex> it = this.groupMembers.iterator();
        while (it.hasNext()) {
            vertices.add(it.next());
        }
    }

    public ManagementStage getStage() {
        return this.stage;
    }

    public ManagementGraph getGraph() {
        return this.stage.getGraph();
    }

    public int getNumberOfGroupMembers() {
        return this.groupMembers.size();
    }

    public ManagementVertex getGroupMember(int index) {
        if (index < this.groupMembers.size()) {
            return this.groupMembers.get(index);
        }
        return null;
    }

    public List<ManagementVertex> getGroupMembers() {
        return this.groupMembers;
    }

    public boolean isInputVertex() {
        if (this.backwardEdges.size() == 0) {
            return true;
        }
        Iterator<ManagementGroupEdge> it = this.backwardEdges.iterator();
        while (it.hasNext()) {
            if (it.next().getSource().getStageNumber() != this.getStageNumber()) continue;
            return false;
        }
        return true;
    }

    public boolean isOutputVertex() {
        if (this.forwardEdges.size() == 0) {
            return true;
        }
        Iterator<ManagementGroupEdge> it = this.forwardEdges.iterator();
        while (it.hasNext()) {
            if (it.next().getTarget().getStageNumber() != this.getStageNumber()) continue;
            return false;
        }
        return true;
    }

    public int getStageNumber() {
        return this.stage.getStageNumber();
    }

    public void read(DataInputView in) throws IOException {
        int numberOfForwardLinks = in.readInt();
        for (int i = 0; i < numberOfForwardLinks; ++i) {
            ManagementGroupVertexID targetGroupVertexID = new ManagementGroupVertexID();
            targetGroupVertexID.read(in);
            ManagementGroupVertex targetGroupVertex = this.getGraph().getGroupVertexByID(targetGroupVertexID);
            int sourceIndex = in.readInt();
            int targetIndex = in.readInt();
            ChannelType channelType = EnumUtils.readEnum((DataInput)in, ChannelType.class);
            new ManagementGroupEdge(this, sourceIndex, targetGroupVertex, targetIndex, channelType);
        }
    }

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.forwardEdges.size());
        for (ManagementGroupEdge groupEdge : this.forwardEdges) {
            groupEdge.getTarget().getID().write(out);
            out.writeInt(groupEdge.getSourceIndex());
            out.writeInt(groupEdge.getTargetIndex());
            EnumUtils.writeEnum((DataOutput)out, groupEdge.getChannelType());
        }
    }

    public List<ManagementGroupVertex> getSuccessors() {
        ArrayList<ManagementGroupVertex> successors = new ArrayList<ManagementGroupVertex>();
        for (ManagementGroupEdge edge : this.forwardEdges) {
            successors.add(edge.getTarget());
        }
        return successors;
    }

    public List<ManagementGroupVertex> getPredecessors() {
        ArrayList<ManagementGroupVertex> predecessors = new ArrayList<ManagementGroupVertex>();
        for (ManagementGroupEdge edge : this.backwardEdges) {
            predecessors.add(edge.getSource());
        }
        return predecessors;
    }

    public String toString() {
        return String.format("ManagementGroupVertex(%s)", this.getName());
    }

    public String toJson() {
        StringBuilder json = new StringBuilder("");
        json.append("{");
        json.append("\"groupvertexid\": \"" + this.getID() + "\",");
        json.append("\"groupvertexname\": \"" + StringUtils.escapeHtml((String)this.getName()) + "\",");
        json.append("\"numberofgroupmembers\": " + this.getNumberOfGroupMembers() + ",");
        json.append("\"groupmembers\": [");
        HashMap<ExecutionState, Integer> stateCounts = new HashMap<ExecutionState, Integer>();
        for (ExecutionState state : ExecutionState.values()) {
            stateCounts.put(state, new Integer(0));
        }
        for (int j = 0; j < this.getNumberOfGroupMembers(); ++j) {
            ManagementVertex vertex = this.getGroupMember(j);
            json.append(vertex.toJson());
            if (j != this.getNumberOfGroupMembers() - 1) {
                json.append(",");
            }
            Integer count = (Integer)stateCounts.get((Object)vertex.getExecutionState()) + new Integer(1);
            stateCounts.put(vertex.getExecutionState(), count);
        }
        json.append("],");
        json.append("\"backwardEdges\": [");
        for (int edgeIndex = 0; edgeIndex < this.getNumberOfBackwardEdges(); ++edgeIndex) {
            ManagementGroupEdge edge = this.getBackwardEdge(edgeIndex);
            json.append("{");
            json.append("\"groupvertexid\": \"" + edge.getSource().getID() + "\",");
            json.append("\"groupvertexname\": \"" + StringUtils.escapeHtml((String)edge.getSource().getName()) + "\",");
            json.append("\"channelType\": \"" + (Object)((Object)edge.getChannelType()) + "\"");
            json.append("}");
            if (edgeIndex == this.getNumberOfBackwardEdges() - 1) continue;
            json.append(",");
        }
        json.append("]");
        for (Map.Entry stateCount : stateCounts.entrySet()) {
            json.append(",\"" + stateCount.getKey() + "\": " + stateCount.getValue());
        }
        json.append("}");
        return json.toString();
    }
}

