/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.managementgraph;

import eu.stratosphere.nephele.managementgraph.ManagementEdge;
import eu.stratosphere.nephele.managementgraph.ManagementGraph;
import eu.stratosphere.nephele.managementgraph.ManagementGroupEdge;
import eu.stratosphere.nephele.managementgraph.ManagementGroupVertex;
import eu.stratosphere.nephele.managementgraph.ManagementVertex;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ManagementGraphIterator
implements Iterator<ManagementVertex> {
    private static final Log LOG = LogFactory.getLog(ManagementGraphIterator.class);
    private final ManagementGraph managementGraph;
    private final boolean forward;
    private final int startStage;
    private final boolean confinedToStage;
    private int numVisitedEntryVertices = 0;
    private final Stack<TraversalEntry> traversalStack = new Stack();
    private final Set<ManagementVertex> alreadyVisited = new HashSet<ManagementVertex>();

    public ManagementGraphIterator(ManagementGraph managementGraph, boolean forward) {
        this(managementGraph, forward ? 0 : managementGraph.getNumberOfStages() - 1, false, forward);
    }

    public ManagementGraphIterator(ManagementGraph managementGraph, int startStage, boolean confinedToStage, boolean forward) {
        this.managementGraph = managementGraph;
        this.forward = forward;
        this.startStage = startStage;
        this.confinedToStage = confinedToStage;
        if (startStage >= this.managementGraph.getNumberOfStages()) {
            return;
        }
        if (forward) {
            if (managementGraph.getNumberOfInputVertices(startStage) > 0) {
                TraversalEntry te = new TraversalEntry(managementGraph.getInputVertex(startStage, 0), 0, 0);
                this.traversalStack.push(te);
                this.alreadyVisited.add(te.getManagementVertex());
            }
        } else if (managementGraph.getNumberOfOutputVertices(startStage) > 0) {
            TraversalEntry te = new TraversalEntry(managementGraph.getOutputVertex(startStage, 0), 0, 0);
            this.traversalStack.push(te);
            this.alreadyVisited.add(te.getManagementVertex());
        }
    }

    public ManagementGraphIterator(ManagementGraph managementGraph, ManagementVertex startVertex, boolean forward) {
        this.managementGraph = managementGraph;
        this.forward = forward;
        this.numVisitedEntryVertices = -1;
        this.startStage = 0;
        this.confinedToStage = false;
        TraversalEntry te = new TraversalEntry(startVertex, 0, 0);
        this.traversalStack.push(te);
        this.alreadyVisited.add(te.getManagementVertex());
    }

    @Override
    public boolean hasNext() {
        if (this.traversalStack.isEmpty()) {
            if (this.numVisitedEntryVertices < 0) {
                return false;
            }
            ++this.numVisitedEntryVertices;
            if (this.forward ? this.managementGraph.getNumberOfInputVertices(this.startStage) <= this.numVisitedEntryVertices : this.managementGraph.getNumberOfOutputVertices(this.startStage) <= this.numVisitedEntryVertices) {
                return false;
            }
        }
        return true;
    }

    @Override
    public ManagementVertex next() {
        if (this.traversalStack.isEmpty()) {
            if (this.numVisitedEntryVertices < 0) {
                return null;
            }
            TraversalEntry newentry = this.forward ? new TraversalEntry(this.managementGraph.getInputVertex(this.startStage, this.numVisitedEntryVertices), 0, 0) : new TraversalEntry(this.managementGraph.getOutputVertex(this.startStage, this.numVisitedEntryVertices), 0, 0);
            this.traversalStack.push(newentry);
            this.alreadyVisited.add(newentry.getManagementVertex());
        }
        ManagementVertex returnVertex = this.traversalStack.peek().getManagementVertex();
        do {
            TraversalEntry te;
            ManagementVertex candidateVertex;
            if ((candidateVertex = this.getCandidateVertex(te = this.traversalStack.peek(), this.forward)) != null) {
                TraversalEntry newte = new TraversalEntry(candidateVertex, 0, 0);
                this.traversalStack.push(newte);
                this.alreadyVisited.add(candidateVertex);
                break;
            }
            this.traversalStack.pop();
        } while (!this.traversalStack.isEmpty());
        return returnVertex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ManagementVertex getCandidateVertex(TraversalEntry te, boolean forward) {
        if (forward) {
            while (true) {
                if (this.confinedToStage && te.getCurrentChannel() == 0) {
                    while (this.currentGateLeadsToOtherStage(te, this.forward)) {
                        te.increaseCurrentGate();
                    }
                }
                if (te.getCurrentGate() >= te.getManagementVertex().getNumberOfOutputGates()) return null;
                if (te.getCurrentChannel() >= te.getManagementVertex().getOutputGate(te.getCurrentGate()).getNumberOfForwardEdges()) {
                    te.increaseCurrentGate();
                    te.resetCurrentChannel();
                    continue;
                }
                ManagementEdge forwardEdge = te.getManagementVertex().getOutputGate(te.getCurrentGate()).getForwardEdge(te.getCurrentChannel());
                ManagementVertex target = forwardEdge.getTarget().getVertex();
                te.increaseCurrentChannel();
                if (!this.alreadyVisited.contains(target)) return target;
            }
        }
        while (true) {
            if (this.confinedToStage && te.getCurrentChannel() == 0) {
                while (this.currentGateLeadsToOtherStage(te, this.forward)) {
                    te.increaseCurrentGate();
                }
            }
            if (te.getCurrentGate() >= te.getManagementVertex().getNumberOfInputGates()) return null;
            if (te.getCurrentChannel() >= te.getManagementVertex().getInputGate(te.getCurrentGate()).getNumberOfBackwardEdges()) {
                te.increaseCurrentGate();
                te.resetCurrentChannel();
                continue;
            }
            ManagementEdge backwardEdge = te.getManagementVertex().getInputGate(te.getCurrentGate()).getBackwardEdge(te.getCurrentChannel());
            ManagementVertex source = backwardEdge.getSource().getVertex();
            if (source == null) {
                LOG.error((Object)"Inconsistency in vertex map found (backward)!");
            }
            te.increaseCurrentChannel();
            if (!this.alreadyVisited.contains(source)) return source;
        }
    }

    private boolean currentGateLeadsToOtherStage(TraversalEntry te, boolean forward) {
        ManagementGroupVertex groupVertex = te.getManagementVertex().getGroupVertex();
        if (forward) {
            if (te.getCurrentGate() >= groupVertex.getNumberOfForwardEdges()) {
                return false;
            }
            ManagementGroupEdge edge = groupVertex.getForwardEdge(te.getCurrentGate());
            if (edge.getTarget().getStageNumber() == groupVertex.getStageNumber()) {
                return false;
            }
        } else {
            if (te.getCurrentGate() >= groupVertex.getNumberOfBackwardEdges()) {
                return false;
            }
            ManagementGroupEdge edge = groupVertex.getBackwardEdge(te.getCurrentGate());
            if (edge.getSource().getStageNumber() == groupVertex.getStageNumber()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void remove() {
    }

    private static class TraversalEntry {
        private final ManagementVertex managementVertex;
        private int currentGate;
        private int currentChannel;

        public TraversalEntry(ManagementVertex managementVertex, int currentGate, int currentChannel) {
            this.managementVertex = managementVertex;
            this.currentGate = currentGate;
            this.currentChannel = currentChannel;
        }

        public ManagementVertex getManagementVertex() {
            return this.managementVertex;
        }

        public int getCurrentGate() {
            return this.currentGate;
        }

        public int getCurrentChannel() {
            return this.currentChannel;
        }

        public void increaseCurrentChannel() {
            ++this.currentChannel;
        }

        public void increaseCurrentGate() {
            ++this.currentGate;
        }

        public void resetCurrentChannel() {
            this.currentChannel = 0;
        }
    }
}

