/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.managementgraph;

import eu.stratosphere.core.io.IOReadableWritable;
import eu.stratosphere.core.io.StringRecord;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.nephele.jobgraph.JobID;
import eu.stratosphere.nephele.managementgraph.ManagementAttachment;
import eu.stratosphere.nephele.managementgraph.ManagementEdge;
import eu.stratosphere.nephele.managementgraph.ManagementEdgeID;
import eu.stratosphere.nephele.managementgraph.ManagementGate;
import eu.stratosphere.nephele.managementgraph.ManagementGraphIterator;
import eu.stratosphere.nephele.managementgraph.ManagementGroupVertex;
import eu.stratosphere.nephele.managementgraph.ManagementGroupVertexID;
import eu.stratosphere.nephele.managementgraph.ManagementGroupVertexIterator;
import eu.stratosphere.nephele.managementgraph.ManagementStage;
import eu.stratosphere.nephele.managementgraph.ManagementVertex;
import eu.stratosphere.nephele.managementgraph.ManagementVertexID;
import eu.stratosphere.nephele.util.EnumUtils;
import eu.stratosphere.runtime.io.channels.ChannelType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ManagementGraph
extends ManagementAttachment
implements IOReadableWritable {
    private final List<ManagementStage> stages = new ArrayList<ManagementStage>();
    private final JobID jobID;
    private final Map<ManagementVertexID, ManagementVertex> vertices = new HashMap<ManagementVertexID, ManagementVertex>();
    private final Map<ManagementGroupVertexID, ManagementGroupVertex> groupVertices = new HashMap<ManagementGroupVertexID, ManagementGroupVertex>();

    public ManagementGraph(JobID jobID) {
        this.jobID = jobID;
    }

    public ManagementGraph() {
        this.jobID = new JobID();
    }

    void addStage(ManagementStage mangementStage) {
        this.stages.add(mangementStage);
    }

    public JobID getJobID() {
        return this.jobID;
    }

    void addVertex(ManagementVertexID id, ManagementVertex vertex) {
        this.vertices.put(id, vertex);
    }

    public ManagementVertex getVertexByID(ManagementVertexID id) {
        return this.vertices.get(id);
    }

    public ManagementGroupVertex getGroupVertexByID(ManagementGroupVertexID id) {
        return this.groupVertices.get(id);
    }

    void addGroupVertex(ManagementGroupVertexID id, ManagementGroupVertex groupVertex) {
        this.groupVertices.put(id, groupVertex);
    }

    public int getNumberOfStages() {
        return this.stages.size();
    }

    public ManagementStage getStage(int index) {
        if (index >= 0 && index < this.stages.size()) {
            return this.stages.get(index);
        }
        return null;
    }

    public int getNumberOfInputGroupVertices(int stage) {
        if (stage < 0 || stage >= this.stages.size()) {
            return 0;
        }
        return this.stages.get(stage).getNumberOfInputGroupVertices();
    }

    public int getNumberOfOutputGroupVertices(int stage) {
        if (stage >= this.stages.size()) {
            return 0;
        }
        return this.stages.get(stage).getNumberOfOutputGroupVertices();
    }

    public ManagementGroupVertex getInputGroupVertex(int stage, int index) {
        if (stage >= this.stages.size()) {
            return null;
        }
        return this.stages.get(stage).getInputGroupVertex(index);
    }

    public ManagementGroupVertex getOutputGroupVertex(int stage, int index) {
        if (stage >= this.stages.size()) {
            return null;
        }
        return this.stages.get(stage).getOutputGroupVertex(index);
    }

    public int getNumberOfInputVertices(int stage) {
        if (stage >= this.stages.size()) {
            return 0;
        }
        return this.stages.get(stage).getNumberOfInputManagementVertices();
    }

    public int getNumberOfOutputVertices(int stage) {
        if (stage >= this.stages.size()) {
            return 0;
        }
        return this.stages.get(stage).getNumberOfInputManagementVertices();
    }

    public ManagementVertex getInputVertex(int stage, int index) {
        if (stage >= this.stages.size()) {
            return null;
        }
        return this.stages.get(stage).getInputManagementVertex(index);
    }

    public ManagementVertex getOutputVertex(int stage, int index) {
        if (stage >= this.stages.size()) {
            return null;
        }
        return this.stages.get(stage).getOutputManagementVertex(index);
    }

    public Collection<ManagementGroupVertex> getGroupVertices() {
        return Collections.unmodifiableCollection(this.groupVertices.values());
    }

    public List<ManagementGroupVertex> getGroupVerticesInTopologicalOrder() {
        ManagementGroupVertex groupVertex;
        ArrayList<ManagementGroupVertex> topologicalSort = new ArrayList<ManagementGroupVertex>();
        ArrayDeque<ManagementGroupVertex> noIncomingEdges = new ArrayDeque<ManagementGroupVertex>();
        HashMap<ManagementGroupVertex, Integer> indegrees = new HashMap<ManagementGroupVertex, Integer>();
        ManagementGroupVertexIterator it = new ManagementGroupVertexIterator(this, true, -1);
        while (it.hasNext()) {
            groupVertex = (ManagementGroupVertex)it.next();
            indegrees.put(groupVertex, groupVertex.getNumberOfBackwardEdges());
            if (groupVertex.getNumberOfBackwardEdges() != 0) continue;
            noIncomingEdges.add(groupVertex);
        }
        while (!noIncomingEdges.isEmpty()) {
            groupVertex = (ManagementGroupVertex)noIncomingEdges.removeFirst();
            topologicalSort.add(groupVertex);
            for (int i = 0; i < groupVertex.getNumberOfForwardEdges(); ++i) {
                ManagementGroupVertex targetVertex = groupVertex.getForwardEdge(i).getTarget();
                Integer indegree = (Integer)indegrees.get(targetVertex);
                indegree = indegree - 1;
                indegrees.put(targetVertex, indegree);
                if (indegree != 0) continue;
                noIncomingEdges.add(targetVertex);
            }
        }
        return topologicalSort;
    }

    public List<ManagementGroupVertex> getGroupVerticesInReverseTopologicalOrder() {
        ManagementGroupVertex groupVertex;
        ArrayList<ManagementGroupVertex> reverseTopologicalSort = new ArrayList<ManagementGroupVertex>();
        ArrayDeque<ManagementGroupVertex> noOutgoingEdges = new ArrayDeque<ManagementGroupVertex>();
        HashMap<ManagementGroupVertex, Integer> outdegrees = new HashMap<ManagementGroupVertex, Integer>();
        ManagementGroupVertexIterator it = new ManagementGroupVertexIterator(this, false, -1);
        while (it.hasNext()) {
            groupVertex = (ManagementGroupVertex)it.next();
            outdegrees.put(groupVertex, groupVertex.getNumberOfForwardEdges());
            if (groupVertex.getNumberOfForwardEdges() != 0) continue;
            noOutgoingEdges.add(groupVertex);
        }
        while (!noOutgoingEdges.isEmpty()) {
            groupVertex = (ManagementGroupVertex)noOutgoingEdges.removeFirst();
            reverseTopologicalSort.add(groupVertex);
            for (int i = 0; i < groupVertex.getNumberOfBackwardEdges(); ++i) {
                ManagementGroupVertex sourceVertex = groupVertex.getBackwardEdge(i).getSource();
                Integer outdegree = (Integer)outdegrees.get(sourceVertex);
                outdegree = outdegree - 1;
                outdegrees.put(sourceVertex, outdegree);
                if (outdegree != 0) continue;
                noOutgoingEdges.add(sourceVertex);
            }
        }
        return reverseTopologicalSort;
    }

    public void read(DataInputView in) throws IOException {
        int i;
        ManagementGroupVertexID groupVertexID;
        int i2;
        this.jobID.read(in);
        int numberOfStages = in.readInt();
        for (int i3 = 0; i3 < numberOfStages; ++i3) {
            new ManagementStage(this, i3);
        }
        int numberOfGroupVertices = in.readInt();
        for (i2 = 0; i2 < numberOfGroupVertices; ++i2) {
            groupVertexID = new ManagementGroupVertexID();
            groupVertexID.read(in);
            ManagementStage stage = this.stages.get(in.readInt());
            String groupVertexName = StringRecord.readString((DataInput)in);
            new ManagementGroupVertex(stage, groupVertexID, groupVertexName);
        }
        for (i2 = 0; i2 < numberOfGroupVertices; ++i2) {
            groupVertexID = new ManagementGroupVertexID();
            groupVertexID.read(in);
            ManagementGroupVertex groupVertex = this.groupVertices.get(groupVertexID);
            groupVertex.read(in);
        }
        int numberOfVertices = in.readInt();
        for (i = 0; i < numberOfVertices; ++i) {
            ManagementVertexID vertexID = new ManagementVertexID();
            vertexID.read(in);
            ManagementGroupVertexID groupVertexID2 = new ManagementGroupVertexID();
            groupVertexID2.read(in);
            ManagementGroupVertex groupVertex = this.getGroupVertexByID(groupVertexID2);
            String instanceName = StringRecord.readString((DataInput)in);
            int indexInGroup = in.readInt();
            ManagementVertex vertex = new ManagementVertex(groupVertex, vertexID, instanceName, indexInGroup);
            vertex.read(in);
        }
        for (i = 0; i < numberOfVertices; ++i) {
            ManagementVertexID sourceID = new ManagementVertexID();
            sourceID.read(in);
            ManagementVertex sourceVertex = this.getVertexByID(sourceID);
            for (int j = 0; j < sourceVertex.getNumberOfOutputGates(); ++j) {
                ManagementGate sourceGate = sourceVertex.getOutputGate(j);
                int numberOfForwardEdges = in.readInt();
                for (int k = 0; k < numberOfForwardEdges; ++k) {
                    ManagementEdgeID sourceEdgeID = new ManagementEdgeID();
                    sourceEdgeID.read(in);
                    ManagementEdgeID targetEdgeID = new ManagementEdgeID();
                    targetEdgeID.read(in);
                    ManagementVertexID targetID = new ManagementVertexID();
                    targetID.read(in);
                    ManagementVertex targetVertex = this.getVertexByID(targetID);
                    int targetGateIndex = in.readInt();
                    ManagementGate targetGate = targetVertex.getInputGate(targetGateIndex);
                    int sourceIndex = in.readInt();
                    int targetIndex = in.readInt();
                    ChannelType channelType = EnumUtils.readEnum((DataInput)in, ChannelType.class);
                    new ManagementEdge(sourceEdgeID, targetEdgeID, sourceGate, sourceIndex, targetGate, targetIndex, channelType);
                }
            }
        }
    }

    public void write(DataOutputView out) throws IOException {
        ManagementGroupVertex groupVertex;
        this.jobID.write(out);
        out.writeInt(this.stages.size());
        out.writeInt(this.groupVertices.size());
        ManagementGroupVertexIterator it = new ManagementGroupVertexIterator(this, true, -1);
        while (it.hasNext()) {
            groupVertex = (ManagementGroupVertex)it.next();
            groupVertex.getID().write(out);
            out.writeInt(groupVertex.getStage().getStageNumber());
            StringRecord.writeString((DataOutput)out, (String)groupVertex.getName());
        }
        it = new ManagementGroupVertexIterator(this, true, -1);
        while (it.hasNext()) {
            groupVertex = (ManagementGroupVertex)it.next();
            groupVertex.getID().write(out);
            groupVertex.write(out);
        }
        out.writeInt(this.vertices.size());
        Iterator<ManagementVertex> it2 = new ManagementGraphIterator(this, true);
        while (it2.hasNext()) {
            ManagementVertex managementVertex = (ManagementVertex)it2.next();
            managementVertex.getID().write(out);
            managementVertex.getGroupVertex().getID().write(out);
            StringRecord.writeString((DataOutput)out, (String)managementVertex.getInstanceName());
            out.writeInt(managementVertex.getIndexInGroup());
            managementVertex.write(out);
        }
        for (ManagementVertex managementVertex : this.vertices.values()) {
            managementVertex.getID().write(out);
            for (int i = 0; i < managementVertex.getNumberOfOutputGates(); ++i) {
                ManagementGate outputGate = managementVertex.getOutputGate(i);
                out.writeInt(outputGate.getNumberOfForwardEdges());
                for (int j = 0; j < outputGate.getNumberOfForwardEdges(); ++j) {
                    ManagementEdge edge = outputGate.getForwardEdge(j);
                    edge.getSourceEdgeID().write(out);
                    edge.getTargetEdgeID().write(out);
                    edge.getTarget().getVertex().getID().write(out);
                    out.writeInt(edge.getTarget().getIndex());
                    out.writeInt(edge.getSourceIndex());
                    out.writeInt(edge.getTargetIndex());
                    EnumUtils.writeEnum((DataOutput)out, edge.getChannelType());
                }
            }
        }
    }
}

