/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.managementgraph;

import eu.stratosphere.nephele.managementgraph.ManagementAttachment;
import eu.stratosphere.nephele.managementgraph.ManagementEdge;
import eu.stratosphere.nephele.managementgraph.ManagementGateID;
import eu.stratosphere.nephele.managementgraph.ManagementGraph;
import eu.stratosphere.nephele.managementgraph.ManagementVertex;
import java.util.ArrayList;
import java.util.List;

public final class ManagementGate
extends ManagementAttachment {
    private final ManagementVertex managementVertex;
    private final boolean isInputGate;
    private final int index;
    private final List<ManagementEdge> forwardEdges = new ArrayList<ManagementEdge>();
    private final List<ManagementEdge> backwardEdges = new ArrayList<ManagementEdge>();
    private ManagementGateID gateID;

    public ManagementGate(ManagementVertex managementVertex, ManagementGateID gateID, int index, boolean isInputGate) {
        this.isInputGate = isInputGate;
        this.managementVertex = managementVertex;
        this.gateID = gateID;
        this.index = index;
        managementVertex.addGate(this);
    }

    public boolean isInputGate() {
        return this.isInputGate;
    }

    void insertForwardEdge(ManagementEdge managementEdge, int index) {
        while (index >= this.forwardEdges.size()) {
            this.forwardEdges.add(null);
        }
        this.forwardEdges.set(index, managementEdge);
    }

    void insertBackwardEdge(ManagementEdge managementEdge, int index) {
        while (index >= this.backwardEdges.size()) {
            this.backwardEdges.add(null);
        }
        this.backwardEdges.set(index, managementEdge);
    }

    public ManagementGraph getGraph() {
        return this.managementVertex.getGraph();
    }

    public int getNumberOfForwardEdges() {
        return this.forwardEdges.size();
    }

    public int getNumberOfBackwardEdges() {
        return this.backwardEdges.size();
    }

    public int getIndex() {
        return this.index;
    }

    public ManagementEdge getForwardEdge(int index) {
        if (index < this.forwardEdges.size()) {
            return this.forwardEdges.get(index);
        }
        return null;
    }

    public ManagementEdge getBackwardEdge(int index) {
        if (index < this.backwardEdges.size()) {
            return this.backwardEdges.get(index);
        }
        return null;
    }

    public ManagementVertex getVertex() {
        return this.managementVertex;
    }

    public ManagementGateID getManagementGateID() {
        return this.gateID;
    }
}

