/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.jobmanager.web;

import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.configuration.GlobalConfiguration;
import eu.stratosphere.nephele.instance.Instance;
import eu.stratosphere.nephele.instance.InstanceConnectionInfo;
import eu.stratosphere.nephele.jobmanager.JobManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class SetupInfoServlet
extends HttpServlet {
    private static final long serialVersionUID = 3704963598772630435L;
    private static final Log LOG = LogFactory.getLog(SetupInfoServlet.class);
    private Configuration globalC = GlobalConfiguration.getConfiguration();
    private JobManager jobmanager;

    public SetupInfoServlet(JobManager jm) {
        this.jobmanager = jm;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setStatus(200);
        resp.setContentType("application/json");
        if ("globalC".equals(req.getParameter("get"))) {
            this.writeGlobalConfiguration(resp);
        } else if ("taskmanagers".equals(req.getParameter("get"))) {
            this.writeTaskmanagers(resp);
        }
    }

    private void writeGlobalConfiguration(HttpServletResponse resp) throws IOException {
        Set keys = this.globalC.keySet();
        ArrayList list = new ArrayList(keys);
        Collections.sort(list);
        JSONObject obj = new JSONObject();
        for (String k : list) {
            try {
                obj.put(k, (Object)this.globalC.getString(k, ""));
            }
            catch (JSONException e) {
                LOG.warn((Object)"Json object creation failed", (Throwable)e);
            }
        }
        PrintWriter w = resp.getWriter();
        w.write(obj.toString());
    }

    private void writeTaskmanagers(HttpServletResponse resp) throws IOException {
        Set<InstanceConnectionInfo> keys = this.jobmanager.getInstances().keySet();
        ArrayList<InstanceConnectionInfo> list = new ArrayList<InstanceConnectionInfo>(keys);
        Collections.sort(list);
        JSONObject obj = new JSONObject();
        JSONArray array = new JSONArray();
        for (InstanceConnectionInfo k : list) {
            JSONObject objInner = new JSONObject();
            Instance instance = this.jobmanager.getInstances().get(k);
            long time = new Date().getTime() - instance.getLastHeartBeat();
            try {
                objInner.put("inetAdress", (Object)k.getInetAdress());
                objInner.put("ipcPort", k.ipcPort());
                objInner.put("dataPort", k.dataPort());
                objInner.put("timeSinceLastHeartbeat", time / 1000L);
                objInner.put("slotsNumber", instance.getNumberOfSlots());
                objInner.put("freeSlots", instance.getNumberOfAvailableSlots());
                objInner.put("cpuCores", instance.getHardwareDescription().getNumberOfCPUCores());
                objInner.put("physicalMemory", instance.getHardwareDescription().getSizeOfPhysicalMemory() / 0x100000L);
                objInner.put("freeMemory", instance.getHardwareDescription().getSizeOfFreeMemory() / 0x100000L);
                array.put((Object)objInner);
            }
            catch (JSONException e) {
                LOG.warn((Object)"Json object creation failed", (Throwable)e);
            }
        }
        try {
            obj.put("taskmanagers", (Object)array);
        }
        catch (JSONException e) {
            LOG.warn((Object)"Json object creation failed", (Throwable)e);
        }
        PrintWriter w = resp.getWriter();
        w.write(obj.toString());
    }
}

