/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.jobmanager.web;

import eu.stratosphere.api.common.accumulators.AccumulatorHelper;
import eu.stratosphere.nephele.event.job.AbstractEvent;
import eu.stratosphere.nephele.event.job.ExecutionStateChangeEvent;
import eu.stratosphere.nephele.event.job.JobEvent;
import eu.stratosphere.nephele.event.job.RecentJobEvent;
import eu.stratosphere.nephele.execution.ExecutionState;
import eu.stratosphere.nephele.jobgraph.JobID;
import eu.stratosphere.nephele.jobgraph.JobStatus;
import eu.stratosphere.nephele.jobmanager.JobManager;
import eu.stratosphere.nephele.managementgraph.ManagementGraph;
import eu.stratosphere.nephele.managementgraph.ManagementGraphIterator;
import eu.stratosphere.nephele.managementgraph.ManagementGroupVertex;
import eu.stratosphere.nephele.managementgraph.ManagementGroupVertexID;
import eu.stratosphere.nephele.managementgraph.ManagementVertex;
import eu.stratosphere.nephele.services.accumulators.AccumulatorEvent;
import eu.stratosphere.runtime.util.EnvironmentInformation;
import eu.stratosphere.util.StringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.io.EofException;

public class JobmanagerInfoServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(JobmanagerInfoServlet.class);
    private final JobManager jobmanager;

    public JobmanagerInfoServlet(JobManager jobmanager) {
        this.jobmanager = jobmanager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block16: {
            resp.setStatus(200);
            resp.setContentType("application/json");
            try {
                if ("archive".equals(req.getParameter("get"))) {
                    this.writeJsonForArchive(resp.getWriter(), this.jobmanager.getOldJobs());
                } else if ("job".equals(req.getParameter("get"))) {
                    String jobId = req.getParameter("job");
                    this.writeJsonForArchivedJob(resp.getWriter(), this.jobmanager.getArchive().getJob(JobID.fromHexString(jobId)));
                } else if ("groupvertex".equals(req.getParameter("get"))) {
                    String jobId = req.getParameter("job");
                    String groupvertexId = req.getParameter("groupvertex");
                    this.writeJsonForArchivedJobGroupvertex(resp.getWriter(), this.jobmanager.getArchive().getJob(JobID.fromHexString(jobId)), ManagementGroupVertexID.fromHexString(groupvertexId));
                } else if ("taskmanagers".equals(req.getParameter("get"))) {
                    resp.getWriter().write("{\"taskmanagers\": " + this.jobmanager.getNumberOfTaskTrackers() + "}");
                } else if ("cancel".equals(req.getParameter("get"))) {
                    String jobId = req.getParameter("job");
                    this.jobmanager.cancelJob(JobID.fromHexString(jobId));
                } else if ("updates".equals(req.getParameter("get"))) {
                    String jobId = req.getParameter("job");
                    this.writeJsonUpdatesForJob(resp.getWriter(), JobID.fromHexString(jobId));
                } else if ("version".equals(req.getParameter("get"))) {
                    this.writeJsonForVersion(resp.getWriter());
                } else {
                    this.writeJsonForJobs(resp.getWriter(), this.jobmanager.getRecentJobs());
                }
            }
            catch (Exception e) {
                resp.setStatus(400);
                resp.getWriter().print(e.getMessage());
                if (!LOG.isWarnEnabled()) break block16;
                LOG.warn((Object)StringUtils.stringifyException((Throwable)e));
            }
        }
    }

    private void writeJsonForJobs(PrintWriter wrt, List<RecentJobEvent> jobs) {
        try {
            wrt.write("[");
            for (int i = 0; i < jobs.size(); ++i) {
                RecentJobEvent jobEvent = jobs.get(i);
                this.writeJsonForJob(wrt, jobEvent);
                if (i == jobs.size() - 1) continue;
                wrt.write(",");
            }
            wrt.write("]");
        }
        catch (EofException eof) {
            LOG.info((Object)"Info server for jobmanager: Connection closed by client, EofException");
        }
        catch (IOException ioe) {
            LOG.info((Object)"Info server for jobmanager: Connection closed by client, IOException");
        }
    }

    private void writeJsonForJob(PrintWriter wrt, RecentJobEvent jobEvent) throws IOException {
        ManagementGraph jobManagementGraph = this.jobmanager.getManagementGraph(jobEvent.getJobID());
        wrt.write("{");
        wrt.write("\"jobid\": \"" + jobEvent.getJobID() + "\",");
        wrt.write("\"jobname\": \"" + jobEvent.getJobName() + "\",");
        wrt.write("\"status\": \"" + (Object)((Object)jobEvent.getJobStatus()) + "\",");
        wrt.write("\"time\": " + jobEvent.getTimestamp() + ",");
        wrt.write("\"groupvertices\": [");
        boolean first = true;
        for (ManagementGroupVertex groupVertex : jobManagementGraph.getGroupVerticesInTopologicalOrder()) {
            if (first) {
                first = false;
            } else {
                wrt.write(",");
            }
            wrt.write(groupVertex.toJson());
        }
        wrt.write("]");
        wrt.write("}");
    }

    private void writeJsonForArchive(PrintWriter wrt, List<RecentJobEvent> jobs) {
        wrt.write("[");
        Collections.sort(jobs, new Comparator<RecentJobEvent>(){

            @Override
            public int compare(RecentJobEvent o1, RecentJobEvent o2) {
                if (o1.getTimestamp() < o2.getTimestamp()) {
                    return 1;
                }
                return -1;
            }
        });
        for (int i = 0; i < jobs.size(); ++i) {
            RecentJobEvent jobEvent = jobs.get(i);
            wrt.write("{");
            wrt.write("\"jobid\": \"" + jobEvent.getJobID() + "\",");
            wrt.write("\"jobname\": \"" + jobEvent.getJobName() + "\",");
            wrt.write("\"status\": \"" + (Object)((Object)jobEvent.getJobStatus()) + "\",");
            wrt.write("\"time\": " + jobEvent.getTimestamp());
            wrt.write("}");
            if (i == jobs.size() - 1) continue;
            wrt.write(",");
        }
        wrt.write("]");
    }

    private void writeJsonForArchivedJob(PrintWriter wrt, RecentJobEvent jobEvent) {
        try {
            wrt.write("[");
            ManagementGraph jobManagementGraph = this.jobmanager.getManagementGraph(jobEvent.getJobID());
            wrt.write("{");
            wrt.write("\"jobid\": \"" + jobEvent.getJobID() + "\",");
            wrt.write("\"jobname\": \"" + jobEvent.getJobName() + "\",");
            wrt.write("\"status\": \"" + (Object)((Object)jobEvent.getJobStatus()) + "\",");
            wrt.write("\"SCHEDULED\": " + this.jobmanager.getArchive().getJobTime(jobEvent.getJobID(), JobStatus.SCHEDULED) + ",");
            wrt.write("\"RUNNING\": " + this.jobmanager.getArchive().getJobTime(jobEvent.getJobID(), JobStatus.RUNNING) + ",");
            wrt.write("\"FINISHED\": " + this.jobmanager.getArchive().getJobTime(jobEvent.getJobID(), JobStatus.FINISHED) + ",");
            wrt.write("\"FAILED\": " + this.jobmanager.getArchive().getJobTime(jobEvent.getJobID(), JobStatus.FAILED) + ",");
            wrt.write("\"CANCELED\": " + this.jobmanager.getArchive().getJobTime(jobEvent.getJobID(), JobStatus.CANCELED) + ",");
            wrt.write("\"CREATED\": " + this.jobmanager.getArchive().getJobTime(jobEvent.getJobID(), JobStatus.CREATED) + ",");
            if (jobEvent.getJobStatus() == JobStatus.FAILED) {
                ManagementGraphIterator managementGraphIterator = new ManagementGraphIterator(jobManagementGraph, true);
                wrt.write("\"failednodes\": [");
                HashSet map = new HashSet();
                boolean first = true;
                while (managementGraphIterator.hasNext()) {
                    ManagementVertex managementVertex = managementGraphIterator.next();
                    String instanceName = managementVertex.getInstanceName();
                    if (managementVertex.getExecutionState() != ExecutionState.FAILED || map.contains(instanceName)) continue;
                    if (first) {
                        first = false;
                    } else {
                        wrt.write(",");
                    }
                    wrt.write("{");
                    wrt.write("\"node\": \"" + instanceName + "\",");
                    wrt.write("\"message\": \"" + StringUtils.escapeHtml((String)managementVertex.getOptMessage()) + "\"");
                    wrt.write("}");
                    map.add(instanceName);
                }
                wrt.write("],");
            }
            wrt.write("\"groupvertices\": [");
            boolean first = true;
            for (ManagementGroupVertex groupVertex : jobManagementGraph.getGroupVerticesInTopologicalOrder()) {
                if (first) {
                    first = false;
                } else {
                    wrt.write(",");
                }
                wrt.write(groupVertex.toJson());
            }
            wrt.write("],");
            AccumulatorEvent accumulators = this.jobmanager.getAccumulatorResults(jobEvent.getJobID());
            Map accMap = AccumulatorHelper.toResultMap(accumulators.getAccumulators());
            wrt.write("\n\"accumulators\": [");
            int i = 0;
            for (Map.Entry accumulator : accMap.entrySet()) {
                wrt.write("{ \"name\": \"" + (String)accumulator.getKey() + " (" + accumulator.getValue().getClass().getName() + ")\"," + " \"value\": \"" + accumulator.getValue().toString() + "\"}\n");
                if (++i >= accMap.size()) continue;
                wrt.write(",");
            }
            wrt.write("],\n");
            wrt.write("\"groupverticetimes\": {");
            first = true;
            for (ManagementGroupVertex groupVertex : jobManagementGraph.getGroupVerticesInTopologicalOrder()) {
                if (first) {
                    first = false;
                } else {
                    wrt.write(",");
                }
                long started = Long.MAX_VALUE;
                long ended = 0L;
                for (int j = 0; j < groupVertex.getNumberOfGroupMembers(); ++j) {
                    ManagementVertex vertex = groupVertex.getGroupMember(j);
                    long running = this.jobmanager.getArchive().getVertexTime(jobEvent.getJobID(), vertex.getID(), ExecutionState.RUNNING);
                    if (running != 0L && running < started) {
                        started = running;
                    }
                    long finished = this.jobmanager.getArchive().getVertexTime(jobEvent.getJobID(), vertex.getID(), ExecutionState.FINISHED);
                    long canceled = this.jobmanager.getArchive().getVertexTime(jobEvent.getJobID(), vertex.getID(), ExecutionState.CANCELED);
                    long failed = this.jobmanager.getArchive().getVertexTime(jobEvent.getJobID(), vertex.getID(), ExecutionState.FAILED);
                    if (finished != 0L && finished > ended) {
                        ended = finished;
                    }
                    if (canceled != 0L && canceled > ended) {
                        ended = canceled;
                    }
                    if (failed == 0L || failed <= ended) continue;
                    ended = failed;
                }
                wrt.write("\"" + groupVertex.getID() + "\": {");
                wrt.write("\"groupvertexid\": \"" + groupVertex.getID() + "\",");
                wrt.write("\"groupvertexname\": \"" + groupVertex + "\",");
                wrt.write("\"STARTED\": " + started + ",");
                wrt.write("\"ENDED\": " + ended);
                wrt.write("}");
            }
            wrt.write("}");
            wrt.write("}");
            wrt.write("]");
        }
        catch (EofException eof) {
            LOG.info((Object)"Info server for jobmanager: Connection closed by client, EofException");
        }
        catch (IOException ioe) {
            LOG.info((Object)"Info server for jobmanager: Connection closed by client, IOException");
        }
    }

    private void writeJsonUpdatesForJob(PrintWriter wrt, JobID jobId) {
        try {
            List<AbstractEvent> events = this.jobmanager.getEvents(jobId);
            wrt.write("{");
            wrt.write("\"jobid\": \"" + jobId + "\",");
            wrt.write("\"timestamp\": \"" + System.currentTimeMillis() + "\",");
            wrt.write("\"recentjobs\": [");
            boolean first = true;
            for (RecentJobEvent rje : this.jobmanager.getRecentJobs()) {
                if (first) {
                    first = false;
                } else {
                    wrt.write(",");
                }
                wrt.write("\"" + rje.getJobID().toString() + "\"");
            }
            wrt.write("],");
            wrt.write("\"vertexevents\": [");
            first = true;
            for (AbstractEvent event : events) {
                if (!(event instanceof ExecutionStateChangeEvent)) continue;
                if (first) {
                    first = false;
                } else {
                    wrt.write(",");
                }
                ExecutionStateChangeEvent vertexevent = (ExecutionStateChangeEvent)event;
                wrt.write("{");
                wrt.write("\"vertexid\": \"" + vertexevent.getVertexID() + "\",");
                wrt.write("\"newstate\": \"" + (Object)((Object)vertexevent.getNewExecutionState()) + "\",");
                wrt.write("\"timestamp\": \"" + vertexevent.getTimestamp() + "\"");
                wrt.write("}");
            }
            wrt.write("],");
            wrt.write("\"jobevents\": [");
            first = true;
            for (AbstractEvent event : events) {
                if (!(event instanceof JobEvent)) continue;
                if (first) {
                    first = false;
                } else {
                    wrt.write(",");
                }
                JobEvent jobevent = (JobEvent)event;
                wrt.write("{");
                wrt.write("\"newstate\": \"" + (Object)((Object)jobevent.getCurrentJobStatus()) + "\",");
                wrt.write("\"timestamp\": \"" + jobevent.getTimestamp() + "\"");
                wrt.write("}");
            }
            wrt.write("]");
            wrt.write("}");
        }
        catch (EofException eof) {
            LOG.info((Object)"Info server for jobmanager: Connection closed by client, EofException");
        }
        catch (IOException ioe) {
            LOG.info((Object)"Info server for jobmanager: Connection closed by client, IOException");
        }
    }

    private void writeJsonForArchivedJobGroupvertex(PrintWriter wrt, RecentJobEvent jobEvent, ManagementGroupVertexID groupvertexId) {
        try {
            ManagementGraph jobManagementGraph = this.jobmanager.getManagementGraph(jobEvent.getJobID());
            ManagementGroupVertex groupvertex = jobManagementGraph.getGroupVertexByID(groupvertexId);
            wrt.write("{\"groupvertex\": " + groupvertex.toJson() + ",");
            wrt.write("\"verticetimes\": {");
            boolean first = true;
            for (ManagementGroupVertex groupVertex : jobManagementGraph.getGroupVerticesInTopologicalOrder()) {
                for (int j = 0; j < groupVertex.getNumberOfGroupMembers(); ++j) {
                    ManagementVertex vertex = groupVertex.getGroupMember(j);
                    if (first) {
                        first = false;
                    } else {
                        wrt.write(",");
                    }
                    wrt.write("\"" + vertex.getID() + "\": {");
                    wrt.write("\"vertexid\": \"" + vertex.getID() + "\",");
                    wrt.write("\"vertexname\": \"" + vertex + "\",");
                    wrt.write("\"CREATED\": " + this.jobmanager.getArchive().getVertexTime(jobEvent.getJobID(), vertex.getID(), ExecutionState.CREATED) + ",");
                    wrt.write("\"SCHEDULED\": " + this.jobmanager.getArchive().getVertexTime(jobEvent.getJobID(), vertex.getID(), ExecutionState.SCHEDULED) + ",");
                    wrt.write("\"ASSIGNED\": " + this.jobmanager.getArchive().getVertexTime(jobEvent.getJobID(), vertex.getID(), ExecutionState.ASSIGNED) + ",");
                    wrt.write("\"READY\": " + this.jobmanager.getArchive().getVertexTime(jobEvent.getJobID(), vertex.getID(), ExecutionState.READY) + ",");
                    wrt.write("\"STARTING\": " + this.jobmanager.getArchive().getVertexTime(jobEvent.getJobID(), vertex.getID(), ExecutionState.STARTING) + ",");
                    wrt.write("\"RUNNING\": " + this.jobmanager.getArchive().getVertexTime(jobEvent.getJobID(), vertex.getID(), ExecutionState.RUNNING) + ",");
                    wrt.write("\"FINISHING\": " + this.jobmanager.getArchive().getVertexTime(jobEvent.getJobID(), vertex.getID(), ExecutionState.FINISHING) + ",");
                    wrt.write("\"FINISHED\": " + this.jobmanager.getArchive().getVertexTime(jobEvent.getJobID(), vertex.getID(), ExecutionState.FINISHED) + ",");
                    wrt.write("\"CANCELING\": " + this.jobmanager.getArchive().getVertexTime(jobEvent.getJobID(), vertex.getID(), ExecutionState.CANCELING) + ",");
                    wrt.write("\"CANCELED\": " + this.jobmanager.getArchive().getVertexTime(jobEvent.getJobID(), vertex.getID(), ExecutionState.CANCELED) + ",");
                    wrt.write("\"FAILED\": " + this.jobmanager.getArchive().getVertexTime(jobEvent.getJobID(), vertex.getID(), ExecutionState.FAILED) + "");
                    wrt.write("}");
                }
            }
            wrt.write("}}");
        }
        catch (EofException eof) {
            LOG.info((Object)"Info server for jobmanager: Connection closed by client, EofException");
        }
        catch (IOException ioe) {
            LOG.info((Object)"Info server for jobmanager: Connection closed by client, IOException");
        }
    }

    private void writeJsonForVersion(PrintWriter wrt) {
        wrt.write("{");
        wrt.write("\"version\": \"" + EnvironmentInformation.getVersion() + "\",");
        wrt.write("\"revision\": \"" + EnvironmentInformation.getRevisionInformation().commitId + "\"");
        wrt.write("}");
    }
}

