/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.jobmanager.splitassigner.file;

import eu.stratosphere.core.fs.FileInputSplit;
import eu.stratosphere.nephele.instance.Instance;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FileInputSplitList {
    private static final Log LOG = LogFactory.getLog(FileInputSplitList.class);
    private Set<FileInputSplit> masterSet = new HashSet<FileInputSplit>();
    private Map<Instance, Queue<QueueElem>> instanceMap = new HashMap<Instance, Queue<QueueElem>>();

    synchronized void addSplit(FileInputSplit fileInputSplit) {
        this.masterSet.add(fileInputSplit);
    }

    synchronized FileInputSplit getNextInputSplit(Instance instance) {
        Queue<QueueElem> instanceSplitList = this.getInstanceSplitList(instance);
        do {
            QueueElem candidate;
            if ((candidate = instanceSplitList.poll()) == null) {
                return null;
            }
            if (!this.masterSet.remove(candidate.getInputSplit())) continue;
            if (LOG.isInfoEnabled()) {
                if (candidate.distance == 0) {
                    LOG.info((Object)(instance + " receives local file input split"));
                } else {
                    LOG.info((Object)(instance + " receives remote file input split (distance " + candidate.distance + ")"));
                }
            }
            return candidate.getInputSplit();
        } while (!this.masterSet.isEmpty());
        return null;
    }

    private Queue<QueueElem> getInstanceSplitList(Instance instance) {
        Queue<QueueElem> instanceSplitList = this.instanceMap.get(instance);
        if (instanceSplitList == null) {
            instanceSplitList = new PriorityQueue<QueueElem>();
            for (FileInputSplit split : this.masterSet) {
                String[] hostNames = split.getHostNames();
                if (hostNames == null) {
                    instanceSplitList.add(new QueueElem(split, Integer.MAX_VALUE));
                    continue;
                }
                int minDistance = Integer.MAX_VALUE;
                for (int i = 0; i < hostNames.length; ++i) {
                    int distance = instance.getDistance(hostNames[i]);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Distance between " + instance + " and " + hostNames[i] + " is " + distance));
                    }
                    if (distance >= minDistance) continue;
                    minDistance = distance;
                }
                instanceSplitList.add(new QueueElem(split, minDistance));
            }
            this.instanceMap.put(instance, instanceSplitList);
        }
        return instanceSplitList;
    }

    private final class QueueElem
    implements Comparable<QueueElem> {
        final FileInputSplit inputSplit;
        final int distance;

        private QueueElem(FileInputSplit inputSplit, int distance) {
            this.inputSplit = inputSplit;
            this.distance = distance;
        }

        private FileInputSplit getInputSplit() {
            return this.inputSplit;
        }

        @Override
        public int compareTo(QueueElem o) {
            return this.distance - o.distance;
        }
    }
}

