/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.jobmanager.splitassigner;

import eu.stratosphere.core.io.LocatableInputSplit;
import eu.stratosphere.nephele.instance.Instance;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LocatableInputSplitList {
    private static final Log LOG = LogFactory.getLog(LocatableInputSplitList.class);
    private Set<LocatableInputSplit> masterSet = new HashSet<LocatableInputSplit>();
    private Map<Instance, Queue<QueueElem>> instanceMap = new HashMap<Instance, Queue<QueueElem>>();

    synchronized void addSplit(LocatableInputSplit locatableInputSplit) {
        this.masterSet.add(locatableInputSplit);
    }

    synchronized LocatableInputSplit getNextInputSplit(Instance instance) {
        Queue<QueueElem> instanceSplitList = this.getInstanceSplitList(instance);
        do {
            QueueElem candidate;
            if ((candidate = instanceSplitList.poll()) == null) {
                return null;
            }
            if (!this.masterSet.remove(candidate.getInputSplit())) continue;
            if (LOG.isInfoEnabled()) {
                if (candidate.distance == 0) {
                    LOG.info((Object)(instance + " receives local file input split"));
                } else {
                    LOG.info((Object)(instance + " receives remote file input split (distance " + candidate.distance + ")"));
                }
            }
            return candidate.getInputSplit();
        } while (!this.masterSet.isEmpty());
        return null;
    }

    private Queue<QueueElem> getInstanceSplitList(Instance instance) {
        Queue<QueueElem> instanceSplitList = this.instanceMap.get(instance);
        if (instanceSplitList == null) {
            instanceSplitList = new PriorityQueue<QueueElem>();
            for (LocatableInputSplit split : this.masterSet) {
                String[] hostnames = split.getHostnames();
                if (hostnames == null) {
                    instanceSplitList.add(new QueueElem(split, Integer.MAX_VALUE));
                    continue;
                }
                int minDistance = Integer.MAX_VALUE;
                for (int i = 0; i < hostnames.length; ++i) {
                    int distance = instance.getDistance(hostnames[i]);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Distance between " + instance + " and " + hostnames[i] + " is " + distance));
                    }
                    if (distance >= minDistance) continue;
                    minDistance = distance;
                }
                instanceSplitList.add(new QueueElem(split, minDistance));
            }
            this.instanceMap.put(instance, instanceSplitList);
        }
        return instanceSplitList;
    }

    private final class QueueElem
    implements Comparable<QueueElem> {
        final LocatableInputSplit inputSplit;
        final int distance;

        private QueueElem(LocatableInputSplit inputSplit, int distance) {
            this.inputSplit = inputSplit;
            this.distance = distance;
        }

        private LocatableInputSplit getInputSplit() {
            return this.inputSplit;
        }

        @Override
        public int compareTo(QueueElem o) {
            return this.distance - o.distance;
        }
    }
}

