/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.jobmanager.splitassigner;

import eu.stratosphere.core.io.InputSplit;
import eu.stratosphere.core.io.LocatableInputSplit;
import eu.stratosphere.nephele.executiongraph.ExecutionGroupVertex;
import eu.stratosphere.nephele.executiongraph.ExecutionVertex;
import eu.stratosphere.nephele.instance.Instance;
import eu.stratosphere.nephele.jobmanager.splitassigner.InputSplitAssigner;
import eu.stratosphere.nephele.jobmanager.splitassigner.LocatableInputSplitList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LocatableInputSplitAssigner
implements InputSplitAssigner {
    private static final Log LOG = LogFactory.getLog(LocatableInputSplitAssigner.class);
    private final ConcurrentMap<ExecutionGroupVertex, LocatableInputSplitList> vertexMap = new ConcurrentHashMap<ExecutionGroupVertex, LocatableInputSplitList>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerGroupVertex(ExecutionGroupVertex groupVertex) {
        if (!LocatableInputSplit.class.isAssignableFrom(groupVertex.getInputSplitType())) {
            LOG.error((Object)(groupVertex.getName() + " produces input splits of type " + groupVertex.getInputSplitType() + " and cannot be handled by this split assigner"));
            return;
        }
        InputSplit[] inputSplits = groupVertex.getInputSplits();
        if (inputSplits == null) {
            return;
        }
        if (inputSplits.length == 0) {
            return;
        }
        LocatableInputSplitList splitStore = new LocatableInputSplitList();
        if (this.vertexMap.putIfAbsent(groupVertex, splitStore) != null) {
            LOG.error((Object)(groupVertex.getName() + " appears to be already registered with the locatable input split assigner, ignoring vertex..."));
            return;
        }
        LocatableInputSplitList locatableInputSplitList = splitStore;
        synchronized (locatableInputSplitList) {
            for (int i = 0; i < inputSplits.length; ++i) {
                InputSplit inputSplit = inputSplits[i];
                if (!(inputSplit instanceof LocatableInputSplit)) {
                    LOG.error((Object)("Input split " + i + " of vertex " + groupVertex.getName() + " is of type " + inputSplit.getClass() + ", ignoring split..."));
                    continue;
                }
                splitStore.addSplit((LocatableInputSplit)inputSplit);
            }
        }
    }

    @Override
    public void unregisterGroupVertex(ExecutionGroupVertex groupVertex) {
        this.vertexMap.remove(groupVertex);
    }

    @Override
    public InputSplit getNextInputSplit(ExecutionVertex vertex) {
        ExecutionGroupVertex groupVertex = vertex.getGroupVertex();
        LocatableInputSplitList splitStore = (LocatableInputSplitList)this.vertexMap.get(groupVertex);
        if (splitStore == null) {
            return null;
        }
        Instance instance = vertex.getAllocatedResource().getInstance();
        if (instance == null) {
            LOG.error((Object)"Instance is null, returning random split");
            return null;
        }
        return splitStore.getNextInputSplit(instance);
    }
}

