/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.jobmanager.splitassigner;

import eu.stratosphere.core.io.IOReadableWritable;
import eu.stratosphere.core.io.InputSplit;
import eu.stratosphere.core.io.StringRecord;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.nephele.execution.librarycache.LibraryCacheManager;
import eu.stratosphere.nephele.jobgraph.JobID;
import eu.stratosphere.util.StringUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class InputSplitWrapper
implements IOReadableWritable {
    private JobID jobID;
    private InputSplit inputSplit = null;

    public InputSplitWrapper(JobID jobID, InputSplit inputSplit) {
        if (jobID == null) {
            throw new IllegalArgumentException("Argument jobID must not be null");
        }
        this.jobID = jobID;
        this.inputSplit = inputSplit;
    }

    public InputSplitWrapper() {
        this.jobID = new JobID();
    }

    public void write(DataOutputView out) throws IOException {
        this.jobID.write(out);
        if (this.inputSplit == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            StringRecord.writeString((DataOutput)out, (String)this.inputSplit.getClass().getName());
            this.inputSplit.write(out);
        }
    }

    public void read(DataInputView in) throws IOException {
        this.jobID.read(in);
        if (in.readBoolean()) {
            ClassLoader cl = LibraryCacheManager.getClassLoader(this.jobID);
            if (cl == null) {
                throw new IOException("Cannot find class loader for job " + this.jobID);
            }
            String className = StringRecord.readString((DataInput)in);
            Class<?> splitClass = null;
            try {
                splitClass = Class.forName(className, true, cl);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            try {
                this.inputSplit = (InputSplit)splitClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            catch (IllegalAccessException e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            this.inputSplit.read(in);
        } else {
            this.inputSplit = null;
        }
    }

    public InputSplit getInputSplit() {
        return this.inputSplit;
    }
}

