/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.jobmanager.archive;

import eu.stratosphere.nephele.event.job.AbstractEvent;
import eu.stratosphere.nephele.event.job.ExecutionStateChangeEvent;
import eu.stratosphere.nephele.event.job.JobEvent;
import eu.stratosphere.nephele.event.job.RecentJobEvent;
import eu.stratosphere.nephele.execution.ExecutionState;
import eu.stratosphere.nephele.jobgraph.JobID;
import eu.stratosphere.nephele.jobgraph.JobStatus;
import eu.stratosphere.nephele.jobmanager.archive.ArchiveListener;
import eu.stratosphere.nephele.managementgraph.ManagementGraph;
import eu.stratosphere.nephele.managementgraph.ManagementVertexID;
import eu.stratosphere.nephele.topology.NetworkTopology;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MemoryArchivist
implements ArchiveListener {
    private int max_entries;
    private final Map<JobID, List<AbstractEvent>> collectedEvents = new HashMap<JobID, List<AbstractEvent>>();
    private final Map<JobID, RecentJobEvent> oldJobs = new HashMap<JobID, RecentJobEvent>();
    private final Map<JobID, ManagementGraph> managementGraphs = new HashMap<JobID, ManagementGraph>();
    private final Map<JobID, NetworkTopology> networkTopologies = new HashMap<JobID, NetworkTopology>();
    private final LinkedList<JobID> lru = new LinkedList();

    public MemoryArchivist(int max_entries) {
        this.max_entries = max_entries;
    }

    @Override
    public void archiveEvent(JobID jobId, AbstractEvent event) {
        if (!this.collectedEvents.containsKey(jobId)) {
            this.collectedEvents.put(jobId, new ArrayList());
        }
        this.collectedEvents.get(jobId).add(event);
        this.cleanup(jobId);
    }

    @Override
    public void archiveJobevent(JobID jobId, RecentJobEvent event) {
        this.oldJobs.put(jobId, event);
        this.cleanup(jobId);
    }

    @Override
    public void archiveManagementGraph(JobID jobId, ManagementGraph graph) {
        this.managementGraphs.put(jobId, graph);
        this.cleanup(jobId);
    }

    @Override
    public void archiveNetworkTopology(JobID jobId, NetworkTopology topology) {
        this.networkTopologies.put(jobId, topology);
        this.cleanup(jobId);
    }

    @Override
    public List<RecentJobEvent> getJobs() {
        return new ArrayList<RecentJobEvent>(this.oldJobs.values());
    }

    private void cleanup(JobID jobId) {
        if (!this.lru.contains(jobId)) {
            this.lru.addFirst(jobId);
        }
        if (this.lru.size() > this.max_entries) {
            JobID toRemove = this.lru.removeLast();
            this.collectedEvents.remove(toRemove);
            this.oldJobs.remove(toRemove);
            this.managementGraphs.remove(toRemove);
            this.networkTopologies.remove(toRemove);
        }
    }

    @Override
    public RecentJobEvent getJob(JobID jobId) {
        return this.oldJobs.get(jobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagementGraph getManagementGraph(JobID jobID) {
        Map<JobID, ManagementGraph> map = this.managementGraphs;
        synchronized (map) {
            return this.managementGraphs.get(jobID);
        }
    }

    @Override
    public List<AbstractEvent> getEvents(JobID jobID) {
        return this.collectedEvents.get(jobID);
    }

    @Override
    public long getJobTime(JobID jobID, JobStatus jobStatus) {
        for (AbstractEvent event : this.getEvents(jobID)) {
            if (!(event instanceof JobEvent) || ((JobEvent)event).getCurrentJobStatus() != jobStatus) continue;
            return event.getTimestamp();
        }
        return 0L;
    }

    @Override
    public long getVertexTime(JobID jobID, ManagementVertexID jobVertexID, ExecutionState executionState) {
        for (AbstractEvent event : this.getEvents(jobID)) {
            if (!(event instanceof ExecutionStateChangeEvent) || !((ExecutionStateChangeEvent)event).getVertexID().equals(jobVertexID) || !((ExecutionStateChangeEvent)event).getNewExecutionState().equals((Object)executionState)) continue;
            return event.getTimestamp();
        }
        return 0L;
    }
}

