/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.jobmanager;

import eu.stratosphere.nephele.ExecutionMode;
import eu.stratosphere.nephele.instance.InstanceManager;
import eu.stratosphere.nephele.jobmanager.DeploymentManager;
import eu.stratosphere.nephele.jobmanager.scheduler.DefaultScheduler;
import eu.stratosphere.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobManagerUtils {
    private static final Log LOG = LogFactory.getLog(JobManagerUtils.class);

    private JobManagerUtils() {
    }

    static DefaultScheduler loadScheduler(String schedulerClassName, DeploymentManager deploymentManager, InstanceManager instanceManager) {
        DefaultScheduler scheduler;
        Constructor<?> constructor;
        Class<?> schedulerClass;
        try {
            schedulerClass = Class.forName(schedulerClassName);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("Cannot find class " + schedulerClassName + ": " + StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        try {
            Class[] constructorArgs = new Class[]{DeploymentManager.class, InstanceManager.class};
            constructor = schedulerClass.getConstructor(constructorArgs);
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)("Cannot create scheduler: " + StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        catch (SecurityException e) {
            LOG.error((Object)("Cannot create scheduler: " + StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        try {
            scheduler = (DefaultScheduler)constructor.newInstance(deploymentManager, instanceManager);
        }
        catch (InstantiationException e) {
            LOG.error((Object)("Cannot create scheduler: " + StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)("Cannot create scheduler: " + StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("Cannot create scheduler: " + StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)("Cannot create scheduler: " + StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        return scheduler;
    }

    static InstanceManager loadInstanceManager(String instanceManagerClassName) {
        InstanceManager instanceManager;
        Class<?> instanceManagerClass;
        try {
            instanceManagerClass = Class.forName(instanceManagerClassName);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("Cannot find class " + instanceManagerClassName + ": " + StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        try {
            instanceManager = (InstanceManager)instanceManagerClass.newInstance();
        }
        catch (InstantiationException e) {
            LOG.error((Object)("Cannot create instanceManager: " + StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)("Cannot create instanceManager: " + StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        return instanceManager;
    }

    static String getSchedulerClassName(ExecutionMode executionMode) {
        return "eu.stratosphere.nephele.jobmanager.scheduler.DefaultScheduler";
    }

    static String getInstanceManagerClassName(ExecutionMode executionMode) {
        switch (executionMode) {
            case LOCAL: {
                return "eu.stratosphere.nephele.instance.LocalInstanceManager";
            }
            case CLUSTER: {
                return "eu.stratosphere.nephele.instance.DefaultInstanceManager";
            }
        }
        throw new RuntimeException("Unrecognized Execution Mode.");
    }
}

