/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.jobgraph;

import eu.stratosphere.api.common.io.InputFormat;
import eu.stratosphere.api.common.operators.util.UserCodeWrapper;
import eu.stratosphere.core.io.InputSplit;
import eu.stratosphere.nephele.jobgraph.AbstractJobInputVertex;
import eu.stratosphere.nephele.jobgraph.JobGraph;
import eu.stratosphere.nephele.jobgraph.JobVertexID;
import eu.stratosphere.pact.runtime.task.util.TaskConfig;
import java.io.IOException;

public class JobInputVertex
extends AbstractJobInputVertex {
    private InputFormat<?, ?> inputFormat;

    public JobInputVertex(String name, JobVertexID id, JobGraph jobGraph) {
        super(name, id, jobGraph);
    }

    public JobInputVertex(String name, JobGraph jobGraph) {
        this(name, null, jobGraph);
    }

    public JobInputVertex(JobGraph jobGraph) {
        this(null, jobGraph);
    }

    public void setInputFormat(InputFormat<?, ?> format) {
        this.inputFormat = format;
    }

    public void initializeInputFormatFromTaskConfig(ClassLoader cl) {
        TaskConfig cfg = new TaskConfig(this.getConfiguration());
        UserCodeWrapper wrapper = cfg.getStubWrapper(cl);
        if (wrapper != null) {
            this.inputFormat = (InputFormat)wrapper.getUserCodeObject(InputFormat.class, cl);
            this.inputFormat.configure(cfg.getStubParameters());
        }
    }

    @Override
    public Class<? extends InputSplit> getInputSplitType() {
        if (this.inputFormat == null) {
            return InputSplit.class;
        }
        return this.inputFormat.getInputSplitType();
    }

    @Override
    public InputSplit[] getInputSplits(int minNumSplits) throws IOException {
        if (this.inputFormat == null) {
            return null;
        }
        return this.inputFormat.createInputSplits(minNumSplits);
    }
}

