/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.jobgraph;

import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.core.fs.FSDataInputStream;
import eu.stratosphere.core.fs.FileStatus;
import eu.stratosphere.core.fs.FileSystem;
import eu.stratosphere.core.fs.Path;
import eu.stratosphere.core.io.IOReadableWritable;
import eu.stratosphere.core.io.StringRecord;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.nephele.execution.librarycache.LibraryCacheManager;
import eu.stratosphere.nephele.jobgraph.AbstractJobInputVertex;
import eu.stratosphere.nephele.jobgraph.AbstractJobOutputVertex;
import eu.stratosphere.nephele.jobgraph.AbstractJobVertex;
import eu.stratosphere.nephele.jobgraph.JobID;
import eu.stratosphere.nephele.jobgraph.JobTaskVertex;
import eu.stratosphere.nephele.jobgraph.JobVertexID;
import eu.stratosphere.util.ClassUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JobGraph
implements IOReadableWritable {
    private Map<JobVertexID, AbstractJobInputVertex> inputVertices = new HashMap<JobVertexID, AbstractJobInputVertex>();
    private Map<JobVertexID, AbstractJobOutputVertex> outputVertices = new HashMap<JobVertexID, AbstractJobOutputVertex>();
    private Map<JobVertexID, JobTaskVertex> taskVertices = new HashMap<JobVertexID, JobTaskVertex>();
    private JobID jobID;
    private String jobName;
    private Configuration jobConfiguration = new Configuration();
    private final ArrayList<Path> userJars = new ArrayList();
    private static final int BUFFERSIZE = 8192;
    private volatile AbstractJobVertex[] bufferedAllReachableJobVertices = null;

    public JobGraph() {
        this.jobID = new JobID();
    }

    public JobGraph(String jobName) {
        this();
        this.jobName = jobName;
    }

    public String getName() {
        return this.jobName;
    }

    public Configuration getJobConfiguration() {
        return this.jobConfiguration;
    }

    public void addVertex(AbstractJobInputVertex inputVertex) {
        if (!this.inputVertices.containsKey(inputVertex.getID())) {
            this.inputVertices.put(inputVertex.getID(), inputVertex);
        }
    }

    public void addVertex(JobTaskVertex taskVertex) {
        if (!this.taskVertices.containsKey(taskVertex.getID())) {
            this.taskVertices.put(taskVertex.getID(), taskVertex);
        }
    }

    public void addVertex(AbstractJobOutputVertex outputVertex) {
        if (!this.outputVertices.containsKey(outputVertex.getID())) {
            this.outputVertices.put(outputVertex.getID(), outputVertex);
        }
    }

    public int getNumberOfInputVertices() {
        return this.inputVertices.size();
    }

    public int getNumberOfOutputVertices() {
        return this.outputVertices.size();
    }

    public int getNumberOfTaskVertices() {
        return this.taskVertices.size();
    }

    public Iterator<AbstractJobInputVertex> getInputVertices() {
        Collection<AbstractJobInputVertex> coll = this.inputVertices.values();
        return coll.iterator();
    }

    public Iterator<AbstractJobOutputVertex> getOutputVertices() {
        Collection<AbstractJobOutputVertex> coll = this.outputVertices.values();
        return coll.iterator();
    }

    public Iterator<JobTaskVertex> getTaskVertices() {
        Collection<JobTaskVertex> coll = this.taskVertices.values();
        return coll.iterator();
    }

    public int getNumberOfVertices() {
        return this.inputVertices.size() + this.outputVertices.size() + this.taskVertices.size();
    }

    public AbstractJobVertex[] getAllReachableJobVertices() {
        if (this.bufferedAllReachableJobVertices == null) {
            ArrayList<AbstractJobVertex> collector = new ArrayList<AbstractJobVertex>();
            HashSet<JobVertexID> visited = new HashSet<JobVertexID>();
            Iterator<AbstractJobInputVertex> inputs = this.getInputVertices();
            while (inputs.hasNext()) {
                AbstractJobVertex vertex = inputs.next();
                if (visited.contains(vertex.getID())) continue;
                this.collectVertices(vertex, visited, collector);
            }
            this.bufferedAllReachableJobVertices = collector.toArray(new AbstractJobVertex[0]);
        }
        return this.bufferedAllReachableJobVertices;
    }

    private void collectVertices(AbstractJobVertex jv, HashSet<JobVertexID> visited, List<AbstractJobVertex> collector) {
        visited.add(jv.getID());
        collector.add(jv);
        for (int i = 0; i < jv.getNumberOfForwardConnections(); ++i) {
            AbstractJobVertex vertex = jv.getForwardConnection(i).getConnectedVertex();
            if (visited.contains(vertex.getID())) continue;
            this.collectVertices(vertex, visited, collector);
        }
    }

    public AbstractJobVertex[] getAllJobVertices() {
        int i = 0;
        AbstractJobVertex[] vertices = new AbstractJobVertex[this.inputVertices.size() + this.outputVertices.size() + this.taskVertices.size()];
        Iterator<AbstractJobInputVertex> iv = this.getInputVertices();
        while (iv.hasNext()) {
            vertices[i++] = iv.next();
        }
        Iterator<AbstractJobOutputVertex> ov = this.getOutputVertices();
        while (ov.hasNext()) {
            vertices[i++] = ov.next();
        }
        Iterator<JobTaskVertex> tv = this.getTaskVertices();
        while (tv.hasNext()) {
            vertices[i++] = tv.next();
        }
        return vertices;
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public AbstractJobVertex findVertexByID(JobVertexID id) {
        if (this.inputVertices.containsKey(id)) {
            return this.inputVertices.get(id);
        }
        if (this.outputVertices.containsKey(id)) {
            return this.outputVertices.get(id);
        }
        if (this.taskVertices.containsKey(id)) {
            return this.taskVertices.get(id);
        }
        return null;
    }

    public boolean isWeaklyConnected() {
        AbstractJobVertex[] all;
        AbstractJobVertex[] reachable = this.getAllReachableJobVertices();
        return reachable.length == (all = this.getAllJobVertices()).length;
    }

    public boolean isAcyclic() {
        AbstractJobVertex[] reachable = this.getAllReachableJobVertices();
        HashSet<JobVertexID> temporarilyMarked = new HashSet<JobVertexID>();
        HashSet<JobVertexID> permanentlyMarked = new HashSet<JobVertexID>();
        for (int i = 0; i < reachable.length; ++i) {
            if (!this.detectCycle(reachable[i], temporarilyMarked, permanentlyMarked)) continue;
            return false;
        }
        return true;
    }

    private boolean detectCycle(AbstractJobVertex jv, HashSet<JobVertexID> temporarilyMarked, HashSet<JobVertexID> permanentlyMarked) {
        JobVertexID vertexID = jv.getID();
        if (permanentlyMarked.contains(vertexID)) {
            return false;
        }
        if (temporarilyMarked.contains(vertexID)) {
            return true;
        }
        temporarilyMarked.add(vertexID);
        for (int i = 0; i < jv.getNumberOfForwardConnections(); ++i) {
            if (!this.detectCycle(jv.getForwardConnection(i).getConnectedVertex(), temporarilyMarked, permanentlyMarked)) continue;
            return true;
        }
        permanentlyMarked.add(vertexID);
        return false;
    }

    public AbstractJobVertex areVertexDegreesCorrect() {
        Iterator<AbstractJobInputVertex> iter = this.getInputVertices();
        while (iter.hasNext()) {
            AbstractJobVertex jv = iter.next();
            if (jv.getNumberOfForwardConnections() >= 1 && jv.getNumberOfBackwardConnections() <= 0) continue;
            return jv;
        }
        Iterator<JobTaskVertex> iter2 = this.getTaskVertices();
        while (iter2.hasNext()) {
            AbstractJobVertex jv = iter2.next();
            if (jv.getNumberOfForwardConnections() >= 1 && jv.getNumberOfBackwardConnections() >= 1) continue;
            return jv;
        }
        Iterator<AbstractJobOutputVertex> iter3 = this.getOutputVertices();
        while (iter3.hasNext()) {
            AbstractJobVertex jv = iter3.next();
            if (jv.getNumberOfForwardConnections() <= 0 && jv.getNumberOfBackwardConnections() >= 1) continue;
            return jv;
        }
        return null;
    }

    public void read(DataInputView in) throws IOException {
        this.jobID.read(in);
        this.jobName = StringRecord.readString((DataInput)in);
        this.readRequiredJarFiles(in);
        int numVertices = in.readInt();
        for (int i = 0; i < numVertices; ++i) {
            Constructor cst;
            Class c;
            String className = StringRecord.readString((DataInput)in);
            JobVertexID id = new JobVertexID();
            id.read(in);
            String vertexName = StringRecord.readString((DataInput)in);
            try {
                c = ClassUtils.getRecordByName((String)className);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe.toString());
            }
            try {
                cst = c.getConstructor(String.class, JobVertexID.class, JobGraph.class);
            }
            catch (SecurityException e1) {
                throw new IOException(e1.toString());
            }
            catch (NoSuchMethodException e1) {
                throw new IOException(e1.toString());
            }
            try {
                cst.newInstance(vertexName, id, this);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e.toString());
            }
            catch (InstantiationException e) {
                throw new IOException(e.toString());
            }
            catch (IllegalAccessException e) {
                throw new IOException(e.toString());
            }
            catch (InvocationTargetException e) {
                throw new IOException(e.toString());
            }
        }
        JobVertexID tmpID = new JobVertexID();
        for (int i = 0; i < numVertices; ++i) {
            AbstractJobVertex jv;
            tmpID.read(in);
            if (this.inputVertices.containsKey(tmpID)) {
                jv = this.inputVertices.get(tmpID);
            } else if (this.outputVertices.containsKey(tmpID)) {
                jv = this.outputVertices.get(tmpID);
            } else if (this.taskVertices.containsKey(tmpID)) {
                jv = this.taskVertices.get(tmpID);
            } else {
                throw new IOException("Cannot find vertex with ID " + tmpID + " in any vertex map.");
            }
            jv.read(in);
        }
        ClassLoader cl = LibraryCacheManager.getClassLoader(this.jobID);
        if (cl == null) {
            throw new IOException("Cannot find class loader for job graph " + this.jobID);
        }
        this.jobConfiguration = new Configuration(cl);
        this.jobConfiguration.read(in);
    }

    public void write(DataOutputView out) throws IOException {
        int i;
        this.jobID.write(out);
        StringRecord.writeString((DataOutput)out, (String)this.jobName);
        AbstractJobVertex[] allVertices = this.getAllJobVertices();
        this.writeRequiredJarFiles(out, allVertices);
        out.writeInt(allVertices.length);
        for (i = 0; i < allVertices.length; ++i) {
            String className = allVertices[i].getClass().getName();
            StringRecord.writeString((DataOutput)out, (String)className);
            allVertices[i].getID().write(out);
            StringRecord.writeString((DataOutput)out, (String)allVertices[i].getName());
        }
        for (i = 0; i < allVertices.length; ++i) {
            allVertices[i].getID().write(out);
            allVertices[i].write(out);
        }
        this.jobConfiguration.write(out);
    }

    private void writeRequiredJarFiles(DataOutputView out, AbstractJobVertex[] jobVertices) throws IOException {
        int i;
        FileSystem fs = FileSystem.getLocalFileSystem();
        for (i = 0; i < this.userJars.size(); ++i) {
            if (fs.exists(this.userJars.get(i))) continue;
            throw new IOException("Cannot find jar file " + this.userJars.get(i));
        }
        out.writeInt(this.userJars.size());
        for (i = 0; i < this.userJars.size(); ++i) {
            Path jar = this.userJars.get(i);
            jar.write(out);
            FileStatus file = fs.getFileStatus(jar);
            out.writeLong(file.getLen());
            FSDataInputStream inStream = fs.open(this.userJars.get(i));
            byte[] buf = new byte[8192];
            int read = inStream.read(buf, 0, buf.length);
            while (read > 0) {
                out.write(buf, 0, read);
                read = inStream.read(buf, 0, buf.length);
            }
        }
    }

    private void readRequiredJarFiles(DataInputView in) throws IOException {
        int numJars = in.readInt();
        if (numJars > 0) {
            for (int i = 0; i < numJars; ++i) {
                Path p = new Path();
                p.read(in);
                this.userJars.add(p);
                long sizeOfJar = in.readLong();
                LibraryCacheManager.addLibrary(this.jobID, p, sizeOfJar, (DataInput)in);
            }
        }
        LibraryCacheManager.register(this.jobID, this.userJars.toArray(new Path[0]));
    }

    public void addJar(Path jar) {
        if (jar == null) {
            return;
        }
        if (!this.userJars.contains(jar)) {
            this.userJars.add(jar);
        }
    }

    public Path[] getJars() {
        return this.userJars.toArray(new Path[this.userJars.size()]);
    }

    public AbstractJobVertex findVertexWithNullEdges() {
        AbstractJobVertex[] allVertices = this.getAllJobVertices();
        for (int i = 0; i < allVertices.length; ++i) {
            int j;
            for (j = 0; j < allVertices[i].getNumberOfForwardConnections(); ++j) {
                if (allVertices[i].getForwardConnection(j) != null) continue;
                return allVertices[i];
            }
            for (j = 0; j < allVertices[i].getNumberOfBackwardConnections(); ++j) {
                if (allVertices[i].getBackwardConnection(j) != null) continue;
                return allVertices[i];
            }
        }
        return null;
    }

    public boolean isInstanceDependencyChainAcyclic() {
        AbstractJobVertex[] allVertices = this.getAllJobVertices();
        HashSet<AbstractJobVertex> alreadyVisited = new HashSet<AbstractJobVertex>();
        for (AbstractJobVertex vertex : allVertices) {
            AbstractJobVertex vertexToShareInstancesWith;
            if (alreadyVisited.contains(vertex) || (vertexToShareInstancesWith = vertex.getVertexToShareInstancesWith()) == null) continue;
            HashSet<AbstractJobVertex> cycleMap = new HashSet<AbstractJobVertex>();
            while (vertexToShareInstancesWith != null) {
                if (cycleMap.contains(vertexToShareInstancesWith)) {
                    return false;
                }
                alreadyVisited.add(vertexToShareInstancesWith);
                cycleMap.add(vertexToShareInstancesWith);
                vertexToShareInstancesWith = vertexToShareInstancesWith.getVertexToShareInstancesWith();
            }
        }
        return true;
    }
}

