/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.instance;

import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.configuration.GlobalConfiguration;
import eu.stratosphere.nephele.ExecutionMode;
import eu.stratosphere.nephele.instance.DefaultInstanceManager;
import eu.stratosphere.nephele.taskmanager.TaskManager;
import java.util.ArrayList;
import java.util.List;

public class LocalInstanceManager
extends DefaultInstanceManager {
    private List<TaskManager> taskManagers = new ArrayList<TaskManager>();

    public LocalInstanceManager() throws Exception {
        int numTaskManager = GlobalConfiguration.getInteger((String)"localinstancemanager.numtaskmanager", (int)1);
        ExecutionMode execMode = numTaskManager == 1 ? ExecutionMode.LOCAL : ExecutionMode.CLUSTER;
        for (int i = 0; i < numTaskManager; ++i) {
            Configuration tm = new Configuration();
            int ipcPort = GlobalConfiguration.getInteger((String)"taskmanager.rpc.port", (int)6122);
            int dataPort = GlobalConfiguration.getInteger((String)"taskmanager.data.port", (int)6121);
            tm.setInteger("taskmanager.rpc.port", ipcPort + i);
            tm.setInteger("taskmanager.data.port", dataPort + i);
            GlobalConfiguration.includeConfiguration((Configuration)tm);
            this.taskManagers.add(new TaskManager(execMode));
        }
    }

    @Override
    public void shutdown() {
        for (TaskManager taskManager : this.taskManagers) {
            taskManager.shutdown();
        }
        super.shutdown();
    }
}

