/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.instance;

import eu.stratosphere.core.io.IOReadableWritable;
import eu.stratosphere.core.io.StringRecord;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.util.StringUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class InstanceConnectionInfo
implements IOReadableWritable,
Comparable<InstanceConnectionInfo> {
    private InetAddress inetAddress;
    private int ipcPort;
    private int dataPort;
    private String hostName;
    private String domainName;

    public InstanceConnectionInfo(InetAddress inetAddress, int ipcPort, int dataPort) {
        String fqdn;
        if (inetAddress == null) {
            throw new IllegalArgumentException("Argument inetAddress must not be null");
        }
        if (ipcPort <= 0) {
            throw new IllegalArgumentException("Argument ipcPort must be greater than zero");
        }
        if (dataPort <= 0) {
            throw new IllegalArgumentException("Argument dataPort must be greater than zero");
        }
        this.inetAddress = inetAddress;
        String hostAddStr = inetAddress.getHostAddress();
        if (hostAddStr.equals(fqdn = inetAddress.getCanonicalHostName())) {
            this.hostName = fqdn;
            this.domainName = null;
        } else {
            int firstDot = fqdn.indexOf(46);
            if (firstDot == -1) {
                this.hostName = fqdn;
                this.domainName = null;
            } else {
                this.hostName = fqdn.substring(0, firstDot);
                this.domainName = fqdn.substring(firstDot + 1);
            }
        }
        this.ipcPort = ipcPort;
        this.dataPort = dataPort;
    }

    public InstanceConnectionInfo(InetAddress inetAddress, String hostName, String domainName, int ipcPort, int dataPort) {
        if (inetAddress == null) {
            throw new IllegalArgumentException("Argument inetAddress must not be null");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Argument hostName must not be null");
        }
        if (ipcPort <= 0) {
            throw new IllegalArgumentException("Argument ipcPort must be greater than zero");
        }
        if (dataPort <= 0) {
            throw new IllegalArgumentException("Argument dataPort must be greater than zero");
        }
        this.inetAddress = inetAddress;
        this.hostName = hostName;
        this.domainName = domainName;
        this.ipcPort = ipcPort;
        this.dataPort = dataPort;
    }

    public InstanceConnectionInfo() {
    }

    public int ipcPort() {
        return this.ipcPort;
    }

    public int dataPort() {
        return this.dataPort;
    }

    public InetAddress address() {
        return this.inetAddress;
    }

    public String hostname() {
        return this.hostName;
    }

    public String domainName() {
        return this.domainName;
    }

    public String getInetAdress() {
        return this.inetAddress.toString();
    }

    public void read(DataInputView in) throws IOException {
        int addr_length = in.readInt();
        byte[] address = new byte[addr_length];
        in.readFully(address);
        this.hostName = StringRecord.readString((DataInput)in);
        this.domainName = StringRecord.readString((DataInput)in);
        try {
            this.inetAddress = InetAddress.getByAddress(address);
        }
        catch (UnknownHostException uhe) {
            throw new IOException(StringUtils.stringifyException((Throwable)uhe));
        }
        this.ipcPort = in.readInt();
        this.dataPort = in.readInt();
    }

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.inetAddress.getAddress().length);
        out.write(this.inetAddress.getAddress());
        StringRecord.writeString((DataOutput)out, (String)this.hostName);
        StringRecord.writeString((DataOutput)out, (String)this.domainName);
        out.writeInt(this.ipcPort);
        out.writeInt(this.dataPort);
    }

    public String toString() {
        String iaString;
        String portsString = " (ipcPort=" + this.ipcPort + ", dataPort=" + this.dataPort + ")";
        if (this.hostName != null) {
            iaString = this.hostName + portsString;
        } else {
            iaString = this.inetAddress.toString();
            iaString = iaString.replace("/", "");
            iaString = iaString + portsString;
        }
        return iaString;
    }

    public boolean equals(Object obj) {
        if (obj instanceof InstanceConnectionInfo) {
            InstanceConnectionInfo ici = (InstanceConnectionInfo)obj;
            if (!this.inetAddress.equals(ici.address())) {
                return false;
            }
            if (this.ipcPort != ici.ipcPort()) {
                return false;
            }
            return this.dataPort == ici.dataPort();
        }
        return false;
    }

    public int hashCode() {
        return this.inetAddress.hashCode();
    }

    @Override
    public int compareTo(InstanceConnectionInfo o) {
        return this.address().getHostName().compareTo(o.address().getHostName());
    }
}

