/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.instance;

import eu.stratosphere.nephele.deployment.TaskDeploymentDescriptor;
import eu.stratosphere.nephele.execution.librarycache.LibraryCacheManager;
import eu.stratosphere.nephele.execution.librarycache.LibraryCacheProfileRequest;
import eu.stratosphere.nephele.execution.librarycache.LibraryCacheProfileResponse;
import eu.stratosphere.nephele.execution.librarycache.LibraryCacheUpdate;
import eu.stratosphere.nephele.executiongraph.ExecutionVertexID;
import eu.stratosphere.nephele.instance.AllocatedResource;
import eu.stratosphere.nephele.instance.AllocatedSlot;
import eu.stratosphere.nephele.instance.AllocationID;
import eu.stratosphere.nephele.instance.HardwareDescription;
import eu.stratosphere.nephele.instance.InstanceConnectionInfo;
import eu.stratosphere.nephele.instance.InstanceException;
import eu.stratosphere.nephele.ipc.RPC;
import eu.stratosphere.nephele.jobgraph.JobID;
import eu.stratosphere.nephele.net.NetUtils;
import eu.stratosphere.nephele.protocols.TaskOperationProtocol;
import eu.stratosphere.nephele.taskmanager.TaskCancelResult;
import eu.stratosphere.nephele.taskmanager.TaskKillResult;
import eu.stratosphere.nephele.taskmanager.TaskSubmissionResult;
import eu.stratosphere.nephele.topology.NetworkNode;
import eu.stratosphere.nephele.topology.NetworkTopology;
import eu.stratosphere.runtime.io.channels.ChannelID;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Instance
extends NetworkNode {
    private final InstanceConnectionInfo instanceConnectionInfo;
    private final HardwareDescription hardwareDescription;
    private final int numberOfSlots;
    private final Map<AllocationID, AllocatedSlot> allocatedSlots = new HashMap<AllocationID, AllocatedSlot>();
    private TaskOperationProtocol taskManager = null;
    private long lastReceivedHeartBeat = System.currentTimeMillis();

    public Instance(InstanceConnectionInfo instanceConnectionInfo, NetworkNode parentNode, NetworkTopology networkTopology, HardwareDescription hardwareDescription, int numberOfSlots) {
        super(instanceConnectionInfo == null ? null : instanceConnectionInfo.toString(), parentNode, networkTopology);
        this.instanceConnectionInfo = instanceConnectionInfo;
        this.hardwareDescription = hardwareDescription;
        this.numberOfSlots = numberOfSlots;
    }

    private TaskOperationProtocol getTaskManagerProxy() throws IOException {
        if (this.taskManager == null) {
            this.taskManager = RPC.getProxy(TaskOperationProtocol.class, new InetSocketAddress(this.getInstanceConnectionInfo().address(), this.getInstanceConnectionInfo().ipcPort()), NetUtils.getSocketFactory());
        }
        return this.taskManager;
    }

    private void destroyTaskManagerProxy() {
        if (this.taskManager != null) {
            RPC.stopProxy(this.taskManager);
            this.taskManager = null;
        }
    }

    public final InstanceConnectionInfo getInstanceConnectionInfo() {
        return this.instanceConnectionInfo;
    }

    public HardwareDescription getHardwareDescription() {
        return this.hardwareDescription;
    }

    public synchronized void checkLibraryAvailability(JobID jobID) throws IOException {
        String[] requiredLibraries = LibraryCacheManager.getRequiredJarFiles(jobID);
        if (requiredLibraries == null) {
            throw new IOException("No entry of required libraries for job " + jobID);
        }
        LibraryCacheProfileRequest request = new LibraryCacheProfileRequest();
        request.setRequiredLibraries(requiredLibraries);
        LibraryCacheProfileResponse response = null;
        response = this.getTaskManagerProxy().getLibraryCacheProfile(request);
        for (int k = 0; k < requiredLibraries.length; ++k) {
            if (response.isCached(k)) continue;
            LibraryCacheUpdate update = new LibraryCacheUpdate(requiredLibraries[k]);
            this.getTaskManagerProxy().updateLibraryCache(update);
        }
    }

    public synchronized List<TaskSubmissionResult> submitTasks(List<TaskDeploymentDescriptor> tasks) throws IOException {
        return this.getTaskManagerProxy().submitTasks(tasks);
    }

    public synchronized TaskCancelResult cancelTask(ExecutionVertexID id) throws IOException {
        return this.getTaskManagerProxy().cancelTask(id);
    }

    public synchronized TaskKillResult killTask(ExecutionVertexID id) throws IOException {
        return this.getTaskManagerProxy().killTask(id);
    }

    public synchronized void reportHeartBeat() {
        this.lastReceivedHeartBeat = System.currentTimeMillis();
    }

    public synchronized boolean isStillAlive(long cleanUpInterval) {
        return this.lastReceivedHeartBeat + cleanUpInterval >= System.currentTimeMillis();
    }

    public boolean equals(Object obj) {
        if (this.instanceConnectionInfo == null) {
            return super.equals(obj);
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance abstractInstance = (Instance)obj;
        return this.instanceConnectionInfo.equals(abstractInstance.getInstanceConnectionInfo());
    }

    public int hashCode() {
        if (this.instanceConnectionInfo == null) {
            return super.hashCode();
        }
        return this.instanceConnectionInfo.hashCode();
    }

    public synchronized void logBufferUtilization() throws IOException {
        this.getTaskManagerProxy().logBufferUtilization();
    }

    public synchronized void killTaskManager() throws IOException {
        this.getTaskManagerProxy().killTaskManager();
    }

    public synchronized void invalidateLookupCacheEntries(Set<ChannelID> channelIDs) throws IOException {
        this.getTaskManagerProxy().invalidateLookupCacheEntries(channelIDs);
    }

    public synchronized void destroyProxies() {
        this.destroyTaskManagerProxy();
    }

    public int getNumberOfSlots() {
        return this.numberOfSlots;
    }

    public int getNumberOfAvailableSlots() {
        return this.numberOfSlots - this.allocatedSlots.size();
    }

    public synchronized AllocatedResource allocateSlot(JobID jobID) throws InstanceException {
        if (this.allocatedSlots.size() < this.numberOfSlots) {
            AllocatedSlot slot = new AllocatedSlot(jobID);
            this.allocatedSlots.put(slot.getAllocationID(), slot);
            return new AllocatedResource(this, slot.getAllocationID());
        }
        throw new InstanceException("Overbooking instance " + this.instanceConnectionInfo + ".");
    }

    public synchronized void releaseSlot(AllocationID allocationID) {
        if (!this.allocatedSlots.containsKey(allocationID)) {
            throw new RuntimeException("There is no slot registered with allocation ID " + allocationID + ".");
        }
        this.allocatedSlots.remove(allocationID);
    }

    public Collection<AllocatedSlot> getAllocatedSlots() {
        return this.allocatedSlots.values();
    }

    public Collection<AllocatedSlot> removeAllocatedSlots() {
        ArrayList<AllocatedSlot> slots = new ArrayList<AllocatedSlot>(this.allocatedSlots.values());
        for (AllocatedSlot slot : slots) {
            this.releaseSlot(slot.getAllocationID());
        }
        return slots;
    }

    public long getLastHeartBeat() {
        return this.lastReceivedHeartBeat;
    }
}

