/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.instance;

import eu.stratosphere.nephele.instance.HardwareDescription;
import eu.stratosphere.util.OperatingSystem;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HardwareDescriptionFactory {
    private static final Log LOG = LogFactory.getLog(HardwareDescriptionFactory.class);
    private static final String LINUX_MEMORY_INFO_PATH = "/proc/meminfo";
    private static final Pattern LINUX_MEMORY_REGEX = Pattern.compile("^MemTotal:\\s*(\\d+)\\s+kB$");

    private HardwareDescriptionFactory() {
    }

    public static HardwareDescription extractFromSystem() {
        int numberOfCPUCores = Runtime.getRuntime().availableProcessors();
        long sizeOfPhysicalMemory = HardwareDescriptionFactory.getSizeOfPhysicalMemory();
        if (sizeOfPhysicalMemory < 0L) {
            sizeOfPhysicalMemory = 1L;
        }
        long sizeOfFreeMemory = HardwareDescriptionFactory.getSizeOfFreeMemory();
        return new HardwareDescription(numberOfCPUCores, sizeOfPhysicalMemory, sizeOfFreeMemory);
    }

    public static HardwareDescription construct(int numberOfCPUCores, long sizeOfPhysicalMemory, long sizeOfFreeMemory) {
        return new HardwareDescription(numberOfCPUCores, sizeOfPhysicalMemory, sizeOfFreeMemory);
    }

    private static long getSizeOfFreeMemory() {
        Runtime r = Runtime.getRuntime();
        long available = r.maxMemory() - r.totalMemory() + r.freeMemory();
        return available;
    }

    private static long getSizeOfPhysicalMemory() {
        switch (OperatingSystem.getCurrentOperatingSystem()) {
            case LINUX: {
                return HardwareDescriptionFactory.getSizeOfPhysicalMemoryForLinux();
            }
            case WINDOWS: {
                return HardwareDescriptionFactory.getSizeOfPhysicalMemoryForWindows();
            }
            case MAC_OS: {
                return HardwareDescriptionFactory.getSizeOfPhysicalMemoryForMac();
            }
            case FREE_BSD: {
                return HardwareDescriptionFactory.getSizeOfPhysicalMemoryForFreeBSD();
            }
            case UNKNOWN: {
                LOG.error((Object)"Cannot determine size of physical memory for unknown operating system");
                return -1L;
            }
        }
        LOG.error((Object)"Unrecognized OS");
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getSizeOfPhysicalMemoryForLinux() {
        long l;
        BufferedReader lineReader = null;
        try {
            lineReader = new BufferedReader(new FileReader(LINUX_MEMORY_INFO_PATH));
            String line = null;
            while ((line = lineReader.readLine()) != null) {
                Matcher matcher = LINUX_MEMORY_REGEX.matcher(line);
                if (!matcher.matches()) continue;
                String totalMemory = matcher.group(1);
                long l2 = Long.parseLong(totalMemory) * 1024L;
                return l2;
            }
            LOG.error((Object)"Cannot determine the size of the physical memory using '/proc/meminfo'. Unexpected format.");
            l = -1L;
        }
        catch (NumberFormatException e) {
            LOG.error((Object)"Cannot determine the size of the physical memory using '/proc/meminfo'. Unexpected format.");
            long l3 = -1L;
            return l3;
        }
        catch (IOException e) {
            LOG.error((Object)("Cannot determine the size of the physical memory using '/proc/meminfo': " + e.getMessage()), (Throwable)e);
            long l4 = -1L;
            return l4;
        }
        finally {
            try {
                if (lineReader != null) {
                    lineReader.close();
                }
            }
            catch (Throwable t) {}
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getSizeOfPhysicalMemoryForMac() {
        BufferedReader bi = null;
        try {
            String line;
            Process proc = Runtime.getRuntime().exec("sysctl hw.memsize");
            bi = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while ((line = bi.readLine()) != null) {
                if (!line.startsWith("hw.memsize")) continue;
                long memsize = Long.parseLong(line.split(":")[1].trim());
                bi.close();
                proc.destroy();
                long l = memsize;
                return l;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
            long l = -1L;
            return l;
        }
        finally {
            if (bi != null) {
                try {
                    bi.close();
                }
                catch (IOException ioe) {}
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getSizeOfPhysicalMemoryForFreeBSD() {
        long l;
        BufferedReader bi = null;
        try {
            String line;
            Process proc = Runtime.getRuntime().exec("sysctl hw.physmem");
            bi = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while ((line = bi.readLine()) != null) {
                if (!line.startsWith("hw.physmem")) continue;
                long memsize = Long.parseLong(line.split(":")[1].trim());
                bi.close();
                proc.destroy();
                long l2 = memsize;
                return l2;
            }
            LOG.error((Object)"Cannot determine the size of the physical memory using 'sysctl hw.physmem'.");
            l = -1L;
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot determine the size of the physical memory using 'sysctl hw.physmem': " + e.getMessage()), (Throwable)e);
            long l3 = -1L;
            return l3;
        }
        finally {
            if (bi != null) {
                try {
                    bi.close();
                }
                catch (IOException ioe) {}
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getSizeOfPhysicalMemoryForWindows() {
        long l;
        BufferedReader bi = null;
        try {
            Process proc = Runtime.getRuntime().exec("wmic memorychip get capacity");
            bi = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = bi.readLine();
            if (line == null) {
                long l2 = -1L;
                return l2;
            }
            if (!line.startsWith("Capacity")) {
                long l3 = -1L;
                return l3;
            }
            long sizeOfPhyiscalMemory = 0L;
            while ((line = bi.readLine()) != null) {
                if (line.isEmpty()) continue;
                line = line.replaceAll(" ", "");
                sizeOfPhyiscalMemory += Long.parseLong(line);
            }
            l = sizeOfPhyiscalMemory;
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot determine the size of the physical memory using 'wmic memorychip': " + e.getMessage()), (Throwable)e);
            long l4 = -1L;
            return l4;
        }
        finally {
            if (bi != null) {
                try {
                    bi.close();
                }
                catch (Throwable t) {}
            }
        }
        return l;
    }
}

