/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.instance;

import eu.stratosphere.nephele.executiongraph.ExecutionVertex;
import eu.stratosphere.nephele.instance.AllocationID;
import eu.stratosphere.nephele.instance.Instance;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class AllocatedResource {
    private final Instance instance;
    private final AllocationID allocationID;
    private final Set<ExecutionVertex> assignedVertices = Collections.newSetFromMap(new ConcurrentHashMap());

    public AllocatedResource(Instance instance, AllocationID allocationID) {
        this.instance = instance;
        this.allocationID = allocationID;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public AllocationID getAllocationID() {
        return this.allocationID;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AllocatedResource) {
            AllocatedResource allocatedResource = (AllocatedResource)obj;
            if (!this.instance.equals(allocatedResource.getInstance())) {
                return false;
            }
            return !(this.allocationID == null ? allocatedResource.getAllocationID() != null : !this.allocationID.equals(allocatedResource.getAllocationID()));
        }
        return false;
    }

    public int hashCode() {
        if (this.allocationID == null) {
            return 0;
        }
        return this.allocationID.hashCode();
    }

    public void assignVertexToResource(ExecutionVertex vertex) {
        if (!this.assignedVertices.add(vertex)) {
            throw new IllegalStateException("The vertex " + vertex + " has already been assigned to resource " + this);
        }
    }

    public Iterator<ExecutionVertex> assignedVertices() {
        return this.assignedVertices.iterator();
    }

    public void removeVertexFromResource(ExecutionVertex vertex) {
        if (!this.assignedVertices.remove(vertex)) {
            throw new IllegalStateException("The vertex " + vertex + " has not been assigned to resource " + this);
        }
    }
}

