/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.executiongraph;

import eu.stratosphere.nephele.executiongraph.ExecutionEdge;
import eu.stratosphere.nephele.executiongraph.ExecutionGate;
import eu.stratosphere.nephele.executiongraph.ExecutionGraph;
import eu.stratosphere.nephele.executiongraph.ExecutionGraphIterator;
import eu.stratosphere.nephele.executiongraph.ExecutionGroupEdge;
import eu.stratosphere.nephele.executiongraph.ExecutionGroupVertex;
import eu.stratosphere.nephele.executiongraph.ExecutionStage;
import eu.stratosphere.nephele.executiongraph.ExecutionVertex;
import eu.stratosphere.nephele.instance.Instance;
import eu.stratosphere.nephele.managementgraph.ManagementEdge;
import eu.stratosphere.nephele.managementgraph.ManagementEdgeID;
import eu.stratosphere.nephele.managementgraph.ManagementGate;
import eu.stratosphere.nephele.managementgraph.ManagementGateID;
import eu.stratosphere.nephele.managementgraph.ManagementGraph;
import eu.stratosphere.nephele.managementgraph.ManagementGroupEdge;
import eu.stratosphere.nephele.managementgraph.ManagementGroupVertex;
import eu.stratosphere.nephele.managementgraph.ManagementStage;
import eu.stratosphere.nephele.managementgraph.ManagementVertex;
import eu.stratosphere.runtime.io.channels.ChannelType;
import java.util.HashMap;
import java.util.Map;

public class ManagementGraphFactory {
    private ManagementGraphFactory() {
    }

    public static ManagementGraph fromExecutionGraph(ExecutionGraph executionGraph) {
        ManagementGraph managementGraph = new ManagementGraph(executionGraph.getJobID());
        Map<ExecutionStage, ManagementStage> stageMap = ManagementGraphFactory.addExecutionStages(managementGraph, executionGraph);
        Map<ExecutionGroupVertex, ManagementGroupVertex> groupMap = ManagementGraphFactory.addGroupVertices(stageMap);
        ManagementGraphFactory.addExecutionVertices(groupMap, executionGraph);
        return managementGraph;
    }

    private static Map<ExecutionStage, ManagementStage> addExecutionStages(ManagementGraph managementGraph, ExecutionGraph executionGraph) {
        HashMap<ExecutionStage, ManagementStage> stageMap = new HashMap<ExecutionStage, ManagementStage>();
        for (int i = 0; i < executionGraph.getNumberOfStages(); ++i) {
            ExecutionStage executionStage = executionGraph.getStage(i);
            ManagementStage managementStage = new ManagementStage(managementGraph, i);
            stageMap.put(executionStage, managementStage);
        }
        return stageMap;
    }

    private static Map<ExecutionGroupVertex, ManagementGroupVertex> addGroupVertices(Map<ExecutionStage, ManagementStage> stageMap) {
        ExecutionStage executionStage;
        HashMap<ExecutionGroupVertex, ManagementGroupVertex> groupMap = new HashMap<ExecutionGroupVertex, ManagementGroupVertex>();
        for (Map.Entry<ExecutionStage, ManagementStage> entry : stageMap.entrySet()) {
            executionStage = entry.getKey();
            ManagementStage parent = entry.getValue();
            for (int i = 0; i < executionStage.getNumberOfStageMembers(); ++i) {
                ExecutionGroupVertex groupVertex = executionStage.getStageMember(i);
                ManagementGroupVertex managementGroupVertex = new ManagementGroupVertex(parent, groupVertex.getName());
                groupMap.put(groupVertex, managementGroupVertex);
            }
        }
        for (Map.Entry<ExecutionStage, ManagementStage> entry : stageMap.entrySet()) {
            executionStage = entry.getKey();
            for (int i = 0; i < executionStage.getNumberOfStageMembers(); ++i) {
                ExecutionGroupVertex sourceVertex = executionStage.getStageMember(i);
                ManagementGroupVertex sourceGroupVertex = (ManagementGroupVertex)groupMap.get(sourceVertex);
                for (int j = 0; j < sourceVertex.getNumberOfForwardLinks(); ++j) {
                    ExecutionGroupEdge edge = sourceVertex.getForwardEdge(j);
                    ExecutionGroupVertex targetVertex = edge.getTargetVertex();
                    ManagementGroupVertex targetGroupVertex = (ManagementGroupVertex)groupMap.get(targetVertex);
                    new ManagementGroupEdge(sourceGroupVertex, j, targetGroupVertex, edge.getIndexOfInputGate(), edge.getChannelType());
                }
            }
        }
        return groupMap;
    }

    private static void addExecutionVertices(Map<ExecutionGroupVertex, ManagementGroupVertex> groupMap, ExecutionGraph executionGraph) {
        ExecutionGraphIterator iterator = new ExecutionGraphIterator(executionGraph, true);
        HashMap<ExecutionVertex, ManagementVertex> vertexMap = new HashMap<ExecutionVertex, ManagementVertex>();
        HashMap<ExecutionGate, ManagementGate> gateMap = new HashMap<ExecutionGate, ManagementGate>();
        while (iterator.hasNext()) {
            ManagementGate managementGate;
            int i;
            ExecutionVertex ev = iterator.next();
            ManagementGroupVertex parent = groupMap.get(ev.getGroupVertex());
            Instance instance = ev.getAllocatedResource().getInstance();
            ManagementVertex managementVertex = new ManagementVertex(parent, ev.getID().toManagementVertexID(), instance.getInstanceConnectionInfo() != null ? instance.getInstanceConnectionInfo().toString() : instance.toString(), ev.getIndexInVertexGroup());
            managementVertex.setExecutionState(ev.getExecutionState());
            vertexMap.put(ev, managementVertex);
            for (i = 0; i < ev.getNumberOfOutputGates(); ++i) {
                ExecutionGate outputGate = ev.getOutputGate(i);
                managementGate = new ManagementGate(managementVertex, new ManagementGateID(), i, false);
                gateMap.put(outputGate, managementGate);
            }
            for (i = 0; i < ev.getNumberOfInputGates(); ++i) {
                ExecutionGate inputGate = ev.getInputGate(i);
                managementGate = new ManagementGate(managementVertex, new ManagementGateID(), i, true);
                gateMap.put(inputGate, managementGate);
            }
        }
        iterator = new ExecutionGraphIterator(executionGraph, true);
        while (iterator.hasNext()) {
            ExecutionVertex source = iterator.next();
            for (int i = 0; i < source.getNumberOfOutputGates(); ++i) {
                ExecutionGate outputGate = source.getOutputGate(i);
                ManagementGate manangementOutputGate = (ManagementGate)gateMap.get(outputGate);
                ChannelType channelType = outputGate.getChannelType();
                for (int j = 0; j < outputGate.getNumberOfEdges(); ++j) {
                    ExecutionEdge outputChannel = outputGate.getEdge(j);
                    ManagementGate managementInputGate = (ManagementGate)gateMap.get(outputChannel.getInputGate());
                    ManagementEdgeID sourceEdgeID = new ManagementEdgeID(outputChannel.getOutputChannelID());
                    ManagementEdgeID targetEdgeID = new ManagementEdgeID(outputChannel.getInputChannelID());
                    new ManagementEdge(sourceEdgeID, targetEdgeID, manangementOutputGate, j, managementInputGate, outputChannel.getInputGateIndex(), channelType);
                }
            }
        }
    }
}

