/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.executiongraph;

import eu.stratosphere.nephele.execution.ExecutionState;
import eu.stratosphere.nephele.executiongraph.ExecutionVertex;
import eu.stratosphere.nephele.instance.AllocatedResource;
import eu.stratosphere.nephele.util.UnmodifiableIterator;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;

public final class ExecutionPipeline {
    private final CopyOnWriteArrayList<ExecutionVertex> vertices = new CopyOnWriteArrayList();

    void addToPipeline(ExecutionVertex vertex) {
        if (!this.vertices.addIfAbsent(vertex)) {
            throw new IllegalStateException("Vertex " + vertex + " has already been added to pipeline " + this);
        }
    }

    void removeFromPipeline(ExecutionVertex vertex) {
        if (!this.vertices.remove(vertex)) {
            throw new IllegalStateException("Vertex " + vertex + " was not part of the pipeline " + this);
        }
    }

    public Iterator<ExecutionVertex> iterator() {
        return new UnmodifiableIterator<ExecutionVertex>(this.vertices.iterator());
    }

    public boolean isFinishing() {
        Iterator<ExecutionVertex> it = this.vertices.iterator();
        while (it.hasNext()) {
            ExecutionState state = it.next().getExecutionState();
            if (state == ExecutionState.FINISHING || state == ExecutionState.FINISHED) continue;
            return false;
        }
        return true;
    }

    public void setAllocatedResource(AllocatedResource resource) {
        for (ExecutionVertex vertex : this.vertices) {
            vertex.setAllocatedResource(resource);
        }
    }

    public void updateExecutionState(ExecutionState executionState) {
        for (ExecutionVertex vertex : this.vertices) {
            vertex.updateExecutionState(executionState);
        }
    }
}

