/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.executiongraph;

import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.core.io.InputSplit;
import eu.stratosphere.nephele.executiongraph.ExecutionGraph;
import eu.stratosphere.nephele.executiongraph.ExecutionGroupEdge;
import eu.stratosphere.nephele.executiongraph.ExecutionSignature;
import eu.stratosphere.nephele.executiongraph.ExecutionStage;
import eu.stratosphere.nephele.executiongraph.ExecutionVertex;
import eu.stratosphere.nephele.executiongraph.GraphConversionException;
import eu.stratosphere.nephele.instance.AllocatedResource;
import eu.stratosphere.nephele.instance.DummyInstance;
import eu.stratosphere.nephele.jobgraph.DistributionPattern;
import eu.stratosphere.nephele.jobgraph.JobVertexID;
import eu.stratosphere.nephele.template.AbstractInvokable;
import eu.stratosphere.runtime.io.channels.ChannelType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class ExecutionGroupVertex {
    private static final int DEFAULT_EXECUTION_RETRIES = 0;
    private final String name;
    private final JobVertexID jobVertexID;
    private final AtomicBoolean initialGroupMemberAdded = new AtomicBoolean(false);
    private final CopyOnWriteArrayList<ExecutionVertex> groupMembers = new CopyOnWriteArrayList();
    private final int userDefinedNumberOfMembers;
    private final int numberOfExecutionRetries;
    private final AtomicReference<ExecutionGroupVertex> vertexToShareInstancesWith = new AtomicReference<Object>(null);
    private final CopyOnWriteArrayList<ExecutionGroupVertex> verticesSharingInstances = new CopyOnWriteArrayList();
    private final boolean userDefinedVertexToShareInstancesWith;
    private final ExecutionSignature executionSignature;
    private final CopyOnWriteArrayList<ExecutionGroupEdge> forwardLinks = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ExecutionGroupEdge> backwardLinks = new CopyOnWriteArrayList();
    private volatile InputSplit[] inputSplits = null;
    private volatile Class<? extends InputSplit> inputSplitType = null;
    private volatile ExecutionStage executionStage = null;
    private final Configuration configuration;
    private final Class<? extends AbstractInvokable> invokableClass;

    public ExecutionGroupVertex(String name, JobVertexID jobVertexID, ExecutionGraph executionGraph, int userDefinedNumberOfMembers, boolean userDefinedVertexToShareInstanceWith, int numberOfExecutionRetries, Configuration configuration, ExecutionSignature signature, Class<? extends AbstractInvokable> invokableClass) throws Exception {
        this.name = name != null ? name : "";
        this.jobVertexID = jobVertexID;
        this.userDefinedNumberOfMembers = userDefinedNumberOfMembers;
        this.numberOfExecutionRetries = numberOfExecutionRetries >= 0 ? numberOfExecutionRetries : 0;
        this.userDefinedVertexToShareInstancesWith = userDefinedVertexToShareInstanceWith;
        this.configuration = configuration;
        this.executionSignature = signature;
        this.invokableClass = invokableClass;
    }

    public String getName() {
        return this.name;
    }

    public void setExecutionStage(ExecutionStage executionStage) {
        this.executionStage = executionStage;
    }

    public ExecutionStage getExecutionStage() {
        return this.executionStage;
    }

    void addInitialSubtask(ExecutionVertex ev) {
        if (ev == null) {
            throw new IllegalArgumentException("Argument ev must not be null");
        }
        if (this.initialGroupMemberAdded.compareAndSet(false, true)) {
            this.groupMembers.add(ev);
        }
    }

    public ExecutionVertex getGroupMember(int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("Argument pos must be greater or equal to 0");
        }
        try {
            return this.groupMembers.get(pos);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public int getCurrentNumberOfGroupMembers() {
        return this.groupMembers.size();
    }

    ExecutionGroupEdge wireTo(ExecutionGroupVertex groupVertex, int indexOfInputGate, int indexOfOutputGate, ChannelType channelType, boolean userDefinedChannelType, DistributionPattern distributionPattern) throws GraphConversionException {
        try {
            ExecutionGroupEdge previousEdge = this.forwardLinks.get(indexOfOutputGate);
            if (previousEdge != null) {
                throw new GraphConversionException("Output gate " + indexOfOutputGate + " of" + this.getName() + " already has an outgoing edge");
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        ExecutionGroupEdge edge = new ExecutionGroupEdge(this, indexOfOutputGate, groupVertex, indexOfInputGate, channelType, userDefinedChannelType, distributionPattern);
        this.forwardLinks.add(edge);
        groupVertex.wireBackLink(edge);
        return edge;
    }

    boolean isWiredTo(ExecutionGroupVertex groupVertex) {
        for (ExecutionGroupEdge edge : this.forwardLinks) {
            if (edge.getTargetVertex() != groupVertex) continue;
            return true;
        }
        return false;
    }

    private void wireBackLink(ExecutionGroupEdge edge) {
        this.backwardLinks.add(edge);
    }

    public int getNumberOfForwardLinks() {
        return this.forwardLinks.size();
    }

    public int getNumberOfBackwardLinks() {
        return this.backwardLinks.size();
    }

    public int getStageNumber() {
        return this.executionStage.getStageNumber();
    }

    void createInitialExecutionVertices(int initialNumberOfVertices) throws GraphConversionException {
        if (initialNumberOfVertices == this.getCurrentNumberOfGroupMembers()) {
            return;
        }
        if (this.getCurrentNumberOfGroupMembers() != 1) {
            throw new IllegalStateException("This method can only be called for the initial setup of the execution graph");
        }
        if (this.userDefinedNumberOfMembers != -1 && this.userDefinedNumberOfMembers == this.getCurrentNumberOfGroupMembers()) {
            throw new GraphConversionException("Cannot overwrite user defined number of group members");
        }
        ExecutionVertex originalVertex = this.getGroupMember(0);
        int currentNumberOfExecutionVertices = this.getCurrentNumberOfGroupMembers();
        while (currentNumberOfExecutionVertices++ < initialNumberOfVertices) {
            ExecutionVertex vertex = originalVertex.splitVertex();
            vertex.setAllocatedResource(new AllocatedResource(DummyInstance.createDummyInstance(), null));
            this.groupMembers.add(vertex);
        }
        int index = 0;
        for (ExecutionVertex vertex : this.groupMembers) {
            vertex.setIndexInVertexGroup(index++);
        }
    }

    public void setInputSplits(InputSplit[] inputSplits) {
        this.inputSplits = inputSplits;
    }

    public void setInputSplitType(Class<? extends InputSplit> inputSplitType) {
        this.inputSplitType = inputSplitType;
    }

    public InputSplit[] getInputSplits() {
        return this.inputSplits;
    }

    public Class<? extends InputSplit> getInputSplitType() {
        return this.inputSplitType;
    }

    public ExecutionGroupEdge getForwardEdge(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Argument index must be greater than or equal to 0");
        }
        try {
            return this.forwardLinks.get(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public ExecutionGroupEdge getBackwardEdge(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Argument index must be greater than or equal to 0");
        }
        try {
            return this.backwardLinks.get(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public List<ExecutionGroupEdge> getForwardEdges(ExecutionGroupVertex groupVertex) {
        if (groupVertex == null) {
            throw new IllegalArgumentException("Argument groupVertex must not be null");
        }
        ArrayList<ExecutionGroupEdge> edges = new ArrayList<ExecutionGroupEdge>();
        for (ExecutionGroupEdge edge : this.forwardLinks) {
            if (edge.getTargetVertex() != groupVertex) continue;
            edges.add(edge);
        }
        return edges;
    }

    public List<ExecutionGroupEdge> getBackwardEdges(ExecutionGroupVertex groupVertex) {
        if (groupVertex == null) {
            throw new IllegalArgumentException("Argument groupVertex must not be null");
        }
        ArrayList<ExecutionGroupEdge> edges = new ArrayList<ExecutionGroupEdge>();
        for (ExecutionGroupEdge edge : this.backwardLinks) {
            if (edge.getSourceVertex() != groupVertex) continue;
            edges.add(edge);
        }
        return edges;
    }

    boolean isNumberOfMembersUserDefined() {
        return this.userDefinedNumberOfMembers != -1;
    }

    int getUserDefinedNumberOfMembers() {
        return this.userDefinedNumberOfMembers;
    }

    int getNumberOfExecutionRetries() {
        return this.numberOfExecutionRetries;
    }

    void shareInstancesWith(ExecutionGroupVertex groupVertex) throws GraphConversionException {
        if (this.userDefinedVertexToShareInstancesWith && this.vertexToShareInstancesWith.get() != null) {
            throw new GraphConversionException("Cannot overwrite user defined vertex to share instances with");
        }
        if (groupVertex == null) {
            throw new IllegalArgumentException("shareInstancesWith: argument is null!");
        }
        ExecutionGroupVertex oldVertex = this.vertexToShareInstancesWith.getAndSet(groupVertex);
        if (oldVertex != null) {
            oldVertex.removeFromVerticesSharingInstances(this);
        }
        groupVertex.addToVerticesSharingInstances(this);
    }

    boolean isVertexToShareInstanceWithUserDefined() {
        return this.userDefinedVertexToShareInstancesWith;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ExecutionSignature getExecutionSignature() {
        return this.executionSignature;
    }

    private void addToVerticesSharingInstances(ExecutionGroupVertex groupVertex) {
        if (groupVertex == null) {
            throw new IllegalArgumentException("Argument groupVertex must not be null");
        }
        this.verticesSharingInstances.addIfAbsent(groupVertex);
    }

    private void removeFromVerticesSharingInstances(ExecutionGroupVertex groupVertex) {
        if (groupVertex == null) {
            throw new IllegalArgumentException("Argument groupVertex must not be null");
        }
        this.verticesSharingInstances.remove(groupVertex);
    }

    void repairInstanceSharing(Set<AllocatedResource> availableResources) {
        int numberOfRequiredSlots = this.groupMembers.size();
        int resourcesToBeReplaced = Math.min(availableResources.size(), numberOfRequiredSlots);
        HashMap<AllocatedResource, AllocatedResource> replacementMap = new HashMap<AllocatedResource, AllocatedResource>();
        if (resourcesToBeReplaced > 0) {
            Iterator<ExecutionVertex> vertexIt = this.groupMembers.iterator();
            Iterator<AllocatedResource> resourceIt = availableResources.iterator();
            while (replacementMap.size() < resourcesToBeReplaced && vertexIt.hasNext() && resourceIt.hasNext()) {
                ExecutionVertex vertex = vertexIt.next();
                AllocatedResource originalResource = vertex.getAllocatedResource();
                if (replacementMap.containsKey(originalResource)) continue;
                AllocatedResource replacementResource = resourceIt.next();
                replacementMap.put(originalResource, replacementResource);
            }
        }
        for (ExecutionVertex vertex : this.groupMembers) {
            AllocatedResource originalResource = vertex.getAllocatedResource();
            AllocatedResource replacementResource = (AllocatedResource)replacementMap.get(originalResource);
            if (replacementResource != null) {
                vertex.setAllocatedResource(replacementResource);
                continue;
            }
            availableResources.add(originalResource);
        }
        Iterator<ExecutionGroupVertex> groupVertexIt = this.verticesSharingInstances.iterator();
        while (groupVertexIt.hasNext()) {
            groupVertexIt.next().repairInstanceSharing(availableResources);
        }
    }

    public boolean isInputVertex() {
        if (this.backwardLinks.size() == 0) {
            return true;
        }
        Iterator<ExecutionGroupEdge> it = this.backwardLinks.iterator();
        while (it.hasNext()) {
            if (it.next().getSourceVertex().getStageNumber() != this.getStageNumber()) continue;
            return false;
        }
        return true;
    }

    public boolean isOutputVertex() {
        if (this.forwardLinks.size() == 0) {
            return true;
        }
        Iterator<ExecutionGroupEdge> it = this.forwardLinks.iterator();
        while (it.hasNext()) {
            if (it.next().getTargetVertex().getStageNumber() != this.getStageNumber()) continue;
            return false;
        }
        return true;
    }

    public ExecutionGroupVertex getVertexToShareInstancesWith() {
        return this.vertexToShareInstancesWith.get();
    }

    public JobVertexID getJobVertexID() {
        return this.jobVertexID;
    }

    public Iterator<ExecutionVertex> iterator() {
        return this.groupMembers.iterator();
    }

    int calculateConnectionID(int currentConnectionID, Set<ExecutionGroupVertex> alreadyVisited) {
        if (!alreadyVisited.add(this)) {
            return currentConnectionID;
        }
        for (ExecutionGroupEdge backwardLink : this.backwardLinks) {
            backwardLink.setConnectionID(currentConnectionID);
            ++currentConnectionID;
            currentConnectionID = backwardLink.getSourceVertex().calculateConnectionID(currentConnectionID, alreadyVisited);
        }
        return currentConnectionID;
    }

    Class<? extends AbstractInvokable> getInvokableClass() {
        return this.invokableClass;
    }
}

