/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.executiongraph;

import eu.stratosphere.nephele.executiongraph.ExecutionEdge;
import eu.stratosphere.nephele.executiongraph.ExecutionGroupEdge;
import eu.stratosphere.nephele.executiongraph.ExecutionVertex;
import eu.stratosphere.runtime.io.channels.ChannelType;
import eu.stratosphere.runtime.io.gates.GateID;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;

public final class ExecutionGate {
    private final GateID gateID;
    private volatile ExecutionVertex vertex;
    private final ExecutionGroupEdge groupEdge;
    private final boolean isInputGate;
    private final CopyOnWriteArrayList<ExecutionEdge> edges = new CopyOnWriteArrayList();

    ExecutionGate(GateID gateID, ExecutionVertex vertex, ExecutionGroupEdge groupEdge, boolean isInputGate) {
        this.gateID = gateID;
        this.vertex = vertex;
        this.groupEdge = groupEdge;
        this.isInputGate = isInputGate;
    }

    public GateID getGateID() {
        return this.gateID;
    }

    public ExecutionVertex getVertex() {
        return this.vertex;
    }

    public boolean isInputGate() {
        return this.isInputGate;
    }

    public int getNumberOfEdges() {
        return this.edges.size();
    }

    public ExecutionEdge getEdge(int index) {
        return this.edges.get(index);
    }

    void replaceAllEdges(Collection<ExecutionEdge> newEdges) {
        this.edges.clear();
        this.edges.addAll(newEdges);
    }

    public ChannelType getChannelType() {
        return this.groupEdge.getChannelType();
    }

    ExecutionGroupEdge getGroupEdge() {
        return this.groupEdge;
    }
}

