/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.event.task;

import eu.stratosphere.nephele.event.task.AbstractEvent;
import eu.stratosphere.nephele.event.task.AbstractTaskEvent;
import eu.stratosphere.nephele.event.task.EventListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EventNotificationManager {
    private final Map<Class<? extends AbstractTaskEvent>, List<EventListener>> subscriptions = new HashMap<Class<? extends AbstractTaskEvent>, List<EventListener>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeToEvent(EventListener eventListener, Class<? extends AbstractTaskEvent> eventType) {
        Map<Class<? extends AbstractTaskEvent>, List<EventListener>> map = this.subscriptions;
        synchronized (map) {
            List<EventListener> subscribers = this.subscriptions.get(eventType);
            if (subscribers == null) {
                subscribers = new ArrayList<EventListener>();
                this.subscriptions.put(eventType, subscribers);
            }
            subscribers.add(eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeFromEvent(EventListener eventListener, Class<? extends AbstractEvent> eventType) {
        Map<Class<? extends AbstractTaskEvent>, List<EventListener>> map = this.subscriptions;
        synchronized (map) {
            List<EventListener> subscribers = this.subscriptions.get(eventType);
            if (subscribers == null) {
                return;
            }
            subscribers.remove(eventListener);
            if (subscribers.isEmpty()) {
                this.subscriptions.remove(eventType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverEvent(AbstractTaskEvent event) {
        Map<Class<? extends AbstractTaskEvent>, List<EventListener>> map = this.subscriptions;
        synchronized (map) {
            List<EventListener> subscribers = this.subscriptions.get(event.getClass());
            if (subscribers == null) {
                return;
            }
            Iterator<EventListener> it = subscribers.iterator();
            while (it.hasNext()) {
                it.next().eventOccurred(event);
            }
        }
    }
}

