/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.event.job;

import eu.stratosphere.core.io.StringRecord;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.nephele.event.job.AbstractEvent;
import eu.stratosphere.nephele.event.job.ManagementEvent;
import eu.stratosphere.nephele.managementgraph.ManagementVertexID;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class VertexAssignmentEvent
extends AbstractEvent
implements ManagementEvent {
    private ManagementVertexID managementVertexID;
    private String instanceName;

    public VertexAssignmentEvent(long timestamp, ManagementVertexID managementVertexID, String instanceName) {
        super(timestamp);
        this.managementVertexID = managementVertexID;
        this.instanceName = instanceName;
    }

    public VertexAssignmentEvent() {
        this.managementVertexID = new ManagementVertexID();
    }

    public ManagementVertexID getVertexID() {
        return this.managementVertexID;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        this.managementVertexID.read(in);
        this.instanceName = StringRecord.readString((DataInput)in);
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        this.managementVertexID.write(out);
        StringRecord.writeString((DataOutput)out, (String)this.instanceName);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof VertexAssignmentEvent)) {
            return false;
        }
        VertexAssignmentEvent vae = (VertexAssignmentEvent)obj;
        if (!this.managementVertexID.equals(vae.getVertexID())) {
            return false;
        }
        return !(this.instanceName == null ? vae.getInstanceName() != null : !this.instanceName.equals(vae.getInstanceName()));
    }

    @Override
    public int hashCode() {
        if (this.managementVertexID != null) {
            return this.managementVertexID.hashCode();
        }
        return super.hashCode();
    }
}

