/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.event.job;

import eu.stratosphere.core.io.StringRecord;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.nephele.event.job.AbstractEvent;
import eu.stratosphere.nephele.event.job.ManagementEvent;
import eu.stratosphere.nephele.jobgraph.JobID;
import eu.stratosphere.nephele.jobgraph.JobStatus;
import eu.stratosphere.nephele.util.EnumUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class RecentJobEvent
extends AbstractEvent
implements ManagementEvent {
    private JobID jobID;
    private String jobName;
    private JobStatus jobStatus;
    private boolean isProfilingEnabled;
    private long submissionTimestamp;

    public RecentJobEvent(JobID jobID, String jobName, JobStatus jobStatus, boolean isProfilingEnabled, long submissionTimestamp, long timestamp) {
        super(timestamp);
        if (jobStatus == null) {
            throw new IllegalArgumentException("job status must not be null");
        }
        this.jobID = jobID;
        this.jobName = jobName;
        this.jobStatus = jobStatus;
        this.isProfilingEnabled = isProfilingEnabled;
        this.submissionTimestamp = submissionTimestamp;
    }

    public RecentJobEvent() {
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public String getJobName() {
        return this.jobName;
    }

    public boolean isProfilingAvailable() {
        return this.isProfilingEnabled;
    }

    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    public long getSubmissionTimestamp() {
        return this.submissionTimestamp;
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        this.jobID = new JobID();
        this.jobID.read(in);
        this.jobName = StringRecord.readString((DataInput)in);
        this.jobStatus = EnumUtils.readEnum((DataInput)in, JobStatus.class);
        this.isProfilingEnabled = in.readBoolean();
        this.submissionTimestamp = in.readLong();
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        this.jobID.write(out);
        StringRecord.writeString((DataOutput)out, (String)this.jobName);
        EnumUtils.writeEnum((DataOutput)out, this.jobStatus);
        out.writeBoolean(this.isProfilingEnabled);
        out.writeLong(this.submissionTimestamp);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RecentJobEvent)) {
            return false;
        }
        RecentJobEvent newJobEvent = (RecentJobEvent)obj;
        if (!this.jobID.equals(newJobEvent.getJobID())) {
            return false;
        }
        if (!this.jobName.equals(newJobEvent.getJobName())) {
            return false;
        }
        if (this.isProfilingEnabled != newJobEvent.isProfilingAvailable()) {
            return false;
        }
        return this.submissionTimestamp == newJobEvent.getSubmissionTimestamp();
    }

    @Override
    public int hashCode() {
        if (this.jobID != null) {
            return this.jobID.hashCode();
        }
        if (this.jobName != null) {
            return this.jobName.hashCode();
        }
        return super.hashCode();
    }
}

