/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.event.job;

import eu.stratosphere.core.io.StringRecord;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.nephele.event.job.AbstractEvent;
import eu.stratosphere.nephele.jobgraph.JobStatus;
import eu.stratosphere.nephele.util.EnumUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class JobEvent
extends AbstractEvent {
    private JobStatus currentJobStatus;
    private String optionalMessage = null;

    public JobEvent(long timestamp, JobStatus currentJobStatus, String optionalMessage) {
        super(timestamp);
        this.currentJobStatus = currentJobStatus;
        this.optionalMessage = optionalMessage;
    }

    public JobEvent() {
        this.currentJobStatus = JobStatus.SCHEDULED;
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        this.currentJobStatus = EnumUtils.readEnum((DataInput)in, JobStatus.class);
        this.optionalMessage = StringRecord.readString((DataInput)in);
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        EnumUtils.writeEnum((DataOutput)out, this.currentJobStatus);
        StringRecord.writeString((DataOutput)out, (String)this.optionalMessage);
    }

    public JobStatus getCurrentJobStatus() {
        return this.currentJobStatus;
    }

    public String getOptionalMessage() {
        return this.optionalMessage;
    }

    public String toString() {
        return JobEvent.timestampToString(this.getTimestamp()) + ":\tJob execution switched to status " + (Object)((Object)this.currentJobStatus);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof JobEvent)) {
            return false;
        }
        JobEvent jobEvent = (JobEvent)obj;
        if (!this.currentJobStatus.equals((Object)jobEvent.getCurrentJobStatus())) {
            return false;
        }
        if (this.optionalMessage == null) {
            return jobEvent.getOptionalMessage() == null;
        }
        return this.optionalMessage.equals(jobEvent.getOptionalMessage());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

